/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Transformation")
@Description(value={"Represents the transformation of a Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display transformation of {_display} to {_transformation}"})
@Since(value={"2.8.0"})
public class ExprDisplayTransformation
extends SimplePropertyExpression<Entity, Transformation> {
    @Nullable
    public Transformation convert(Entity entity) {
        if (entity instanceof Display) {
            Display display = (Display)entity;
            return display.getTransformation();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Transformation.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Transformation) {
            Transformation transformation = (Transformation)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Display)) continue;
                Display display = (Display)entity;
                display.setTransformation(transformation);
            }
        }
    }

    @NotNull
    public Class<? extends Transformation> getReturnType() {
        return Transformation.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display transformation";
    }

    static {
        ExprDisplayTransformation.register(ExprDisplayTransformation.class, Transformation.class, (String)"display transformation", (String)"entities");
    }
}

