/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - View Range")
@Description(value={"Represents the view range of a Display Entity. This is a client setting and has nothing to do with the server.", "As per McWiki:", "Maximum view range of the entity. When the distance is more than [view_range] x [entityDistanceScaling (client setting)] x 64,", "the entity is not rendered. Defaults to 1.0.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display view range of {_display} to 500"})
@Since(value={"2.8.0"})
public class ExprDisplayViewRange
extends SimplePropertyExpression<Entity, Number> {
    @Nullable
    public Number convert(Entity entity) {
        if (entity instanceof Display) {
            Display display = (Display)entity;
            return Float.valueOf(display.getViewRange());
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        if (mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            float f;
            Object object;
            if (!(entity instanceof Display)) continue;
            Display display = (Display)entity;
            float oldValue = display.getViewRange();
            if (delta != null && (object = delta[0]) instanceof Number) {
                Number num = (Number)object;
                f = num.floatValue();
            } else {
                f = 1.0f;
            }
            float changeValue = f;
            switch (mode) {
                case REMOVE: {
                    changeValue = oldValue - changeValue;
                    break;
                }
                case ADD: {
                    changeValue += oldValue;
                    break;
                }
                case RESET: {
                    changeValue = 1.0f;
                }
            }
            display.setViewRange(changeValue);
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "view range";
    }

    static {
        ExprDisplayViewRange.register(ExprDisplayViewRange.class, Number.class, (String)"display view range", (String)"entities");
    }
}

