/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Interaction - Last Attack/Interaction Player")
@Description(value={"Represents the last player to attack/interact with an Interaction Entity.", "See [**Interaction Entity Data**](https://minecraft.wiki/w/Interaction#Entity_data) on McWiki for more details."})
@Examples(value={"set {_player} to last attack player of {_int}"})
@Since(value={"2.8.1"})
public class ExprInteractionPlayer
extends SimplePropertyExpression<Entity, OfflinePlayer> {
    private boolean interact;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.interact = parseResult.hasTag("i");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public OfflinePlayer convert(Entity entity) {
        if (entity instanceof Interaction) {
            Interaction interaction = (Interaction)entity;
            if (this.interact) {
                Interaction.PreviousInteraction lastInteraction = interaction.getLastInteraction();
                if (lastInteraction != null) {
                    return lastInteraction.getPlayer();
                }
            } else {
                Interaction.PreviousInteraction lastAttack = interaction.getLastAttack();
                if (lastAttack != null) {
                    return lastAttack.getPlayer();
                }
            }
        }
        return null;
    }

    @NotNull
    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "last " + (this.interact ? "interaction" : "attack") + " player";
    }

    static {
        ExprInteractionPlayer.register(ExprInteractionPlayer.class, OfflinePlayer.class, (String)"last (attack|i:interaction) [offline[ ]]player[s]", (String)"entities");
    }
}

