/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Interaction - Is Responsive")
@Description(value={"Represents the state of being responsive of an Interaction Entity.", "See [**Interaction Entity Data**](https://minecraft.wiki/w/Interaction#Entity_data) on McWiki for more details."})
@Examples(value={"set is responsive of {_int} to true"})
@Since(value={"2.8.1"})
public class ExprInteractionResponsive
extends SimplePropertyExpression<Entity, Boolean> {
    @Nullable
    public Boolean convert(Entity entity) {
        if (entity instanceof Interaction) {
            Interaction interaction = (Interaction)entity;
            return interaction.isResponsive();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Boolean) {
            Boolean isResponsive = (Boolean)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Interaction)) continue;
                Interaction interaction = (Interaction)entity;
                interaction.setResponsive(isResponsive.booleanValue());
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "is responsive";
    }

    static {
        ExprInteractionResponsive.register(ExprInteractionResponsive.class, Boolean.class, (String)"is responsive", (String)"entities");
    }
}

