/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Interaction - Last Attack/Interaction Timestamp")
@Description(value={"Represents the timestamp of the last attack/interaction of an Interaction Entity.", "As per Minecraft \"The timestamp of the game tick when the event happened\".", "Appears to be how many ticks since the world was created.", "See [**Interaction Entity Data**](https://minecraft.wiki/w/Interaction#Entity_data) on McWiki for more details."})
@Examples(value={"set {_time} to last attack timestamp of target entity"})
@Since(value={"2.8.1"})
public class ExprInteractionTime
extends SimplePropertyExpression<Entity, Number> {
    private boolean interact;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.interact = parseResult.hasTag("i");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Entity entity) {
        if (entity instanceof Interaction) {
            Interaction interaction = (Interaction)entity;
            if (this.interact) {
                Interaction.PreviousInteraction lastInteraction = interaction.getLastInteraction();
                if (lastInteraction != null) {
                    return lastInteraction.getTimestamp();
                }
            } else {
                Interaction.PreviousInteraction lastAttack = interaction.getLastAttack();
                if (lastAttack != null) {
                    return lastAttack.getTimestamp();
                }
            }
        }
        return null;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "last " + (this.interact ? "interaction" : "attack") + " timestamp";
    }

    static {
        ExprInteractionTime.register(ExprInteractionTime.class, Number.class, (String)"last (attack|i:interaction) timestamp[s]", (String)"entities");
    }
}

