/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Interaction - Interaction Width/Height")
@Description(value={"Represents the interaction width/height of an Interaction Entity.", "See [**Interaction Entity Data**](https://minecraft.wiki/w/Interaction#Entity_data) on McWiki for more details."})
@Examples(value={"set interaction height of last spawned entity to 10", "add 5 to interaction width of {_int}", "remove 2.5 from interaction width of {_int}", "reset interaction height of {_int}"})
@Since(value={"2.8.1"})
public class ExprInteractionWidthHeight
extends SimplePropertyExpression<Entity, Number> {
    private boolean height;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.height = parseResult.hasTag("h");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Entity entity) {
        if (entity instanceof Interaction) {
            Interaction interaction = (Interaction)entity;
            return this.height ? (double)interaction.getInteractionHeight() : (double)interaction.getInteractionWidth();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.RESET, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        float changeValue = 1.0f;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            changeValue = num.floatValue();
        }
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            float oldValue;
            if (!(entity instanceof Interaction)) continue;
            Interaction interaction = (Interaction)entity;
            float f = oldValue = this.height ? interaction.getInteractionHeight() : interaction.getInteractionWidth();
            if (mode == Changer.ChangeMode.ADD) {
                changeValue += oldValue;
            } else if (mode == Changer.ChangeMode.REMOVE) {
                changeValue = oldValue - changeValue;
            } else if (mode == Changer.ChangeMode.RESET) {
                changeValue = 1.0f;
            }
            if (this.height) {
                interaction.setInteractionHeight(changeValue);
                continue;
            }
            interaction.setInteractionWidth(changeValue);
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "interaction " + (this.height ? "height" : "width");
    }

    static {
        ExprInteractionWidthHeight.register(ExprInteractionWidthHeight.class, Number.class, (String)"interaction (width|h:height)", (String)"entities");
    }
}

