/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Display Item")
@Description(value={"Represents the display ItemType of an Item/Block Display Entity", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display item of {_display} to diamond sword", "set display item of {_display} to air", "delete display item of {_display}"})
@Since(value={"2.8.0"})
public class ExprItemDisplayItem
extends SimplePropertyExpression<Entity, ItemType> {
    @Nullable
    public ItemType convert(Entity entity) {
        ItemType itemType = null;
        if (entity instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            ItemStack itemStack = itemDisplay.getItemStack();
            if (itemStack != null) {
                itemType = new ItemType(itemStack);
            }
        } else if (entity instanceof BlockDisplay) {
            BlockDisplay blockDisplay = (BlockDisplay)entity;
            itemType = new ItemType(blockDisplay.getBlock().getMaterial());
        }
        return itemType;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Material material;
        ItemType it;
        Object object;
        ItemType itemType = delta != null && (object = delta[0]) instanceof ItemType ? (it = (ItemType)object) : null;
        ItemStack itemStack = itemType != null ? itemType.getRandom() : null;
        BlockData blockData = Material.AIR.createBlockData();
        if (itemType != null && (material = itemType.getMaterial()).isBlock()) {
            blockData = material.createBlockData();
        }
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (entity instanceof ItemDisplay) {
                ItemDisplay itemDisplay = (ItemDisplay)entity;
                itemDisplay.setItemStack(itemStack);
                continue;
            }
            if (!(entity instanceof BlockDisplay)) continue;
            BlockDisplay blockDisplay = (BlockDisplay)entity;
            blockDisplay.setBlock(blockData);
        }
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display item";
    }

    static {
        ExprItemDisplayItem.register(ExprItemDisplayItem.class, ItemType.class, (String)"display item[[ ]type]", (String)"entities");
    }
}

