/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Item Display Transform")
@Description(value={"Represents the item display transform of an Item Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set item display transform of {_display} to ground transform", "set item display transform of {_display} to fixed transform"})
@Since(value={"2.8.0"})
public class ExprItemDisplayTransform
extends SimplePropertyExpression<Entity, ItemDisplay.ItemDisplayTransform> {
    @Nullable
    public ItemDisplay.ItemDisplayTransform convert(Entity entity) {
        if (entity instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            return itemDisplay.getItemDisplayTransform();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemDisplay.ItemDisplayTransform.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof ItemDisplay.ItemDisplayTransform) {
            ItemDisplay.ItemDisplayTransform transform = (ItemDisplay.ItemDisplayTransform)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof ItemDisplay)) continue;
                ItemDisplay itemDisplay = (ItemDisplay)entity;
                itemDisplay.setItemDisplayTransform(transform);
            }
        }
    }

    @NotNull
    public Class<? extends ItemDisplay.ItemDisplayTransform> getReturnType() {
        return ItemDisplay.ItemDisplayTransform.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "item display transform";
    }

    static {
        ExprItemDisplayTransform.register(ExprItemDisplayTransform.class, ItemDisplay.ItemDisplayTransform.class, (String)"[display] item display transform", (String)"entities");
    }
}

