/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Name(value="Quaternion - Rotated")
@Description(value={"Rotate a quaternion along the XYZ axis using a vector."})
@Examples(value={"function rotateDisplay(e: entity, v: vector):", "\tset {_q} to display right rotation of {_e}", "\tset {_q} to {_q} rotated by {_v}", "\tset display right rotation of {_e} to {_q}", "", "rotateDisplay({_entity}, vector(45,0,0))"})
@Since(value={"3.2.0"})
public class ExprQuaternionRotated
extends SimpleExpression<Quaternionf> {
    private Expression<Quaternionf> quaterions;
    private Expression<Vector> vector;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.quaterions = exprs[0];
        this.vector = exprs[1];
        return true;
    }

    protected Quaternionf @Nullable [] get(Event event) {
        Quaternionf[] quaterions = (Quaternionf[])this.quaterions.getArray(event);
        Vector vector = (Vector)this.vector.getSingle(event);
        if (vector == null) {
            return null;
        }
        float x = (float)Math.toRadians(vector.getX());
        float y = (float)Math.toRadians(vector.getY());
        float z = (float)Math.toRadians(vector.getZ());
        for (int i = 0; i < quaterions.length; ++i) {
            quaterions[i] = quaterions[i].rotateXYZ(x, y, z);
        }
        return quaterions;
    }

    public boolean isSingle() {
        return this.quaterions.isSingle();
    }

    @NotNull
    public Class<? extends Quaternionf> getReturnType() {
        return Quaternionf.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return this.quaterions.toString(e, d) + " rotated by " + this.vector.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprQuaternionRotated.class, Quaternionf.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%quaternions% rotated (by|around) %vector%"});
    }
}

