/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Text Background Color")
@Description(value={"Represents the text background color of a Text Display Entity.", "NOTE: Due to Skript Color missing the alpha channel, you must use Bukkit Colors here.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display text background color of {_display} to bukkitColor(55,100,0,150)"})
@Since(value={"2.8.0"})
public class ExprTextDisplayBackgroundColor
extends SimplePropertyExpression<Entity, Color> {
    @Nullable
    public Color convert(Entity entity) {
        if (entity instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)entity;
            return textDisplay.getBackgroundColor();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Color.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Color) {
            Color color = (Color)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof TextDisplay)) continue;
                TextDisplay textDisplay = (TextDisplay)entity;
                textDisplay.setBackgroundColor(color);
            }
        }
    }

    @NotNull
    public Class<? extends Color> getReturnType() {
        return Color.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "text background color";
    }

    static {
        ExprTextDisplayBackgroundColor.register(ExprTextDisplayBackgroundColor.class, Color.class, (String)"[display] text background color", (String)"entities");
    }
}

