/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fastboard.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.fastboard.FastBoardBase;
import com.shanebeestudios.skbee.api.fastboard.FastBoardManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="FastBoard - Is On")
@Description(value={"Check if a player's fastboard is currently toggled on/off."})
@Examples(value={"if fastboard of player is on:", "\tsend \"Your scoreboard is on!\""})
@Since(value={"1.16.0"})
public class CondFastBoardOn
extends Condition {
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.setNegated(matchedPattern >= 1);
        if (parseResult.hasTag("score")) {
            Skript.warning((String)"'scoreboard' is deprecated, please use 'fastboard' instead.");
        }
        return true;
    }

    public boolean check(Event event) {
        Player player = (Player)this.player.getSingle(event);
        if (player != null) {
            FastBoardBase<?, ?> board = FastBoardManager.getBoard(player);
            if (board == null) {
                return false;
            }
            return board.isOn() ^ this.isNegated();
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "fastboard of " + this.player.toString(e, d) + " is " + (this.isNegated() ? "off" : "on");
    }

    static {
        Skript.registerCondition(CondFastBoardOn.class, (String[])new String[]{"[:score|fast]board of %player% is (on|true)", "[:score|fast]board of %player% is(n't| not) on", "[:score|fast]board of %player% is (off|false)"});
    }
}

