/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fishing.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fish Hook - Pull In")
@Description(value={"Pulls in the entity hooked to this fish hook."})
@Examples(value={"pull in hooked entity of {_fishHook}"})
@Since(value={"2.8.0"})
public class EffFishHookPullIn
extends Effect {
    private Expression<Entity> entities;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        for (Entity entity : (Entity[])this.entities.getArray(event)) {
            if (!(entity instanceof FishHook)) continue;
            FishHook fishHook = (FishHook)entity;
            fishHook.pullHookedEntity();
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "pull in " + this.entities.toString(e, d);
    }

    static {
        Skript.registerEffect(EffFishHookPullIn.class, (String[])new String[]{"pull in hooked entit(y|ies) of %entities%"});
    }
}

