/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fishing.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fish Event Entity")
@Description(value={"Represents the caught entity or hook in a fish event."})
@Examples(value={"on fish:", "\tif fish state = caught fish:", "\t\tset item of fishing caught entity to diamond"})
@Since(value={"1.15.2"})
public class ExprFishEventEntity
extends SimpleExpression<Entity> {
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(PlayerFishEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in a fishing event"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.pattern = matchedPattern;
        return true;
    }

    @Nullable
    protected Entity[] get(Event event) {
        if (!(event instanceof PlayerFishEvent)) {
            return null;
        }
        PlayerFishEvent fishEvent = (PlayerFishEvent)event;
        return new Entity[]{this.pattern == 0 ? fishEvent.getCaught() : fishEvent.getHook()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        String entity = this.pattern == 0 ? "caught entity" : "fish hook";
        return "fish event " + entity;
    }

    static {
        Skript.registerExpression(ExprFishEventEntity.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"fish[ing] [event] caught entity", "fish[ing] [event] hook"});
    }
}

