/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fishing.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fish Hook - Hooked Entity")
@Description(value={"Represents the entity hooked to the fish hook."})
@Examples(value={"on fish:", "\tif fish state = caught entity:", "\t\tdelete hooked entity of fish event hook"})
@Since(value={"2.8.0"})
public class ExprFishHookHookedEntity
extends SimplePropertyExpression<FishHook, Entity> {
    @Nullable
    public Entity convert(FishHook fishHook) {
        return fishHook.getHookedEntity();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Entity.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity hooked = delta != null ? (Entity)delta[0] : null;
        for (FishHook fishHook : (FishHook[])this.getExpr().getArray(event)) {
            fishHook.setHookedEntity(hooked);
        }
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "hooked entity";
    }

    static {
        ExprFishHookHookedEntity.register(ExprFishHookHookedEntity.class, Entity.class, (String)"hooked entity", (String)"entities");
    }
}

