/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.MathUtil;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.event.Event;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Name(value="ChunkGenerator - Populate Tree")
@Description(value={"Grow a tree in a ChunkGenerator `block pop` section.", "The vector represents chunk position not world position."})
@Examples(value={"populate cherry tree at vector(0, 64, 15)"})
@Since(value={"3.5.3"})
public class EffPopulateTree
extends Effect {
    private Expression<TreeType> treeType;
    private Expression<Vector> vector;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.treeType = exprs[0];
        this.vector = exprs[1];
        if (!ParserInstance.get().isCurrentEvent(BlockPopulateEvent.class)) {
            Skript.error((String)"Grow effect using a vector will only work in a 'block pop' section.");
            return false;
        }
        return true;
    }

    protected void execute(Event event) {
        if (!(event instanceof BlockPopulateEvent)) {
            return;
        }
        BlockPopulateEvent popEvent = (BlockPopulateEvent)event;
        TreeType treeType = (TreeType)this.treeType.getSingle(event);
        if (treeType == null) {
            return;
        }
        LimitedRegion region = popEvent.getLimitedRegion();
        Random random = popEvent.getRandom();
        for (Vector vector : (Vector[])this.vector.getArray(event)) {
            int x = (popEvent.getChunkX() << 4) + MathUtil.clamp(vector.getBlockX(), 0, 15);
            int z = (popEvent.getChunkZ() << 4) + MathUtil.clamp(vector.getBlockZ(), 0, 15);
            Location location = new Location(null, (double)x, (double)vector.getBlockY(), (double)z);
            region.generateTree(location, random, treeType);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "populate " + this.treeType.toString(e, d) + " at " + this.vector.toString(e, d);
    }

    static {
        Skript.registerEffect(EffPopulateTree.class, (String[])new String[]{"populate %bukkittreetype% at %vectors%"});
    }
}

