/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.generator.event.ChunkGenEvent;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ChunkGenerator - ChunkData Block")
@Description(value={"Represents blocks in a ChunkData.", "The first pattern is used to set a block in a `chunk gen` or `block pop` section.", "The second pattern is used to fill blocks between 2 points in a `chunk gen` section.", "NOTE: The vector represents the position in a chunk, not a world.", "NOTE: You CAN reach into neighbouring chunks going below 0/above 15 in the vector. I don't know how far you can safely reach though."})
@Examples(value={"chunk gen:", "\tset chunkdata blocks within vector({_x}, 0, {_z}) and vector({_x}, {_y}, {_z}) to red_concrete[]", "\tset chunkdata block at vector({_x}, {_y}, {_z}) to red_concrete_powder[]"})
@Since(value={"3.5.0"})
public class ExprChunkDataBlock
extends SimpleExpression<BlockData> {
    private Expression<Vector> vector;
    private Expression<Vector> vector2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1 && !ParserInstance.get().isCurrentEvent(ChunkGenEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in chunk gen sections."));
            return false;
        }
        if (matchedPattern == 0 && !ParserInstance.get().isCurrentEvent(new Class[]{ChunkGenEvent.class, BlockPopulateEvent.class})) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in chunk gen/block pop sections."));
            return false;
        }
        this.vector = exprs[0];
        if (matchedPattern == 1) {
            this.vector2 = exprs[1];
        }
        return true;
    }

    protected BlockData @Nullable [] get(Event event) {
        Vector vec = (Vector)this.vector.getSingle(event);
        if (vec == null) {
            return null;
        }
        if (event instanceof ChunkGenEvent) {
            ChunkGenEvent chunkGenEvent = (ChunkGenEvent)event;
            int x = vec.getBlockX();
            int y = vec.getBlockY();
            int z = vec.getBlockZ();
            return new BlockData[]{chunkGenEvent.getChunkData().getBlockData(x, y, z)};
        }
        if (event instanceof BlockPopulateEvent) {
            BlockPopulateEvent popEvent = (BlockPopulateEvent)event;
            int x = (popEvent.getChunkX() << 4) + vec.getBlockX();
            int y = vec.getBlockY();
            int z = (popEvent.getChunkZ() << 4) + vec.getBlockZ();
            return new BlockData[]{popEvent.getLimitedRegion().getBlockData(x, y, z)};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{BlockData.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (mode == Changer.ChangeMode.SET && delta != null && (object = delta[0]) instanceof BlockData) {
            Vector vec2;
            BlockData blockData = (BlockData)object;
            Vector vec = (Vector)this.vector.getSingle(event);
            Vector vector = vec2 = this.vector2 != null ? (Vector)this.vector2.getSingle(event) : null;
            if (vec == null) {
                return;
            }
            if (event instanceof ChunkGenEvent) {
                ChunkGenEvent chunkGenEvent = (ChunkGenEvent)event;
                int x = vec.getBlockX();
                int y = vec.getBlockY();
                int z = vec.getBlockZ();
                if (vec2 != null) {
                    int x2 = vec2.getBlockX();
                    int y2 = vec2.getBlockY();
                    int z2 = vec2.getBlockZ();
                    ExprChunkDataBlock.setRegion(chunkGenEvent.getChunkData(), x, y, z, x2, y2, z2, blockData);
                } else {
                    chunkGenEvent.getChunkData().setBlock(x, y, z, blockData);
                }
            } else if (event instanceof BlockPopulateEvent) {
                BlockPopulateEvent popEvent = (BlockPopulateEvent)event;
                int x = (popEvent.getChunkX() << 4) + vec.getBlockX();
                int y = vec.getBlockY();
                int z = (popEvent.getChunkZ() << 4) + vec.getBlockZ();
                LimitedRegion region = popEvent.getLimitedRegion();
                if (region.isInRegion(x, y, z)) {
                    region.setBlockData(x, y, z, blockData);
                }
            }
        }
    }

    @NotNull
    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String vec = this.vector.toString(e, d);
        if (this.vector2 != null) {
            return "chunkdata blockdata within " + vec + " and " + this.vector2.toString(e, d);
        }
        return "chunkdata blockdata at " + vec;
    }

    private static void setRegion(ChunkGenerator.ChunkData chunkData, int x, int y, int z, int x2, int y2, int z2, BlockData blockData) {
        int minX = Math.min(x, x2);
        int minY = Math.min(y, y2);
        int minZ = Math.min(z, z2);
        int maxX = Math.max(x, x2) + 1;
        int maxY = Math.max(y, y2) + 1;
        int maxZ = Math.max(z, z2) + 1;
        chunkData.setRegion(minX, minY, minZ, maxX, maxY, maxZ, blockData);
    }

    static {
        Skript.registerExpression(ExprChunkDataBlock.class, BlockData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"chunk[ ]data block[data] at %vector%", "chunk[ ]data block[data]s (between|within) %vector% (and|to) %vector%"});
    }
}

