/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.generator.event.ChunkGenEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ChunkGenerator - ChunkData X/Z")
@Description(value={"Represents the ChunkData's X/Z coordinates.", "This will typically be used to calculate world position from chunk position for your noise system."})
@Examples(value={"chunk gen:", "\tloop 16 times:", "\t\tloop 16 times:", "\t\t\tset {_x} to (loop-number-1) - 1", "\t\t\tset {_z} to (loop-number-2) - 1", "\t\t\tset {_noise} to getNoise({_x} + (16 * chunkdata chunk x), {_z} + (16 * chunkdata chunk z))"})
@Since(value={"3.5.0"})
public class ExprChunkDataXZ
extends SimpleExpression<Number> {
    private boolean x;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(new Class[]{ChunkGenEvent.class, BlockPopulateEvent.class})) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in chunk gen/block pop sections."));
            return false;
        }
        this.x = parseResult.hasTag("x");
        return true;
    }

    protected Number @Nullable [] get(Event event) {
        if (event instanceof ChunkGenEvent) {
            ChunkGenEvent genEvent = (ChunkGenEvent)event;
            return new Number[]{this.x ? genEvent.getChunkX() : genEvent.getChunkZ()};
        }
        if (event instanceof BlockPopulateEvent) {
            BlockPopulateEvent popEvent = (BlockPopulateEvent)event;
            return new Number[]{this.x ? popEvent.getChunkX() : popEvent.getChunkZ()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "chunkdata chunk " + (this.x ? "x" : "z");
    }

    static {
        Skript.registerExpression(ExprChunkDataXZ.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"chunk[ ]data chunk (:x|z)"});
    }
}

