/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.structure;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.SimpleEvent;
import com.shanebeestudios.skbee.api.generator.BiomeGenerator;
import com.shanebeestudios.skbee.api.generator.ChunkGen;
import com.shanebeestudios.skbee.api.generator.ChunkGenManager;
import com.shanebeestudios.skbee.api.generator.ChunkGenerator;
import com.shanebeestudios.skbee.api.generator.event.BiomeGenEvent;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.generator.event.ChunkGenEvent;
import com.shanebeestudios.skbee.api.generator.event.HeightGenEvent;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.structure.Structure;

@Name(value="ChunkGenerator - Register Generator")
@Description(value={"Register a chunk generator to manipulate the world layout to your liking.", "ENTRIES:", "(These are all optional, and will default to false)", "`vanilla decor` = Whether Minecraft will decorate the surface based on biomes.", "`vanilla caves` = Whether Minecraft will carve caves.", "`vanilla structures` = Whether Minecraft will generate structures based on biomes.", "`vanilla mobs` = Whether Minecraft will spawn mobs based on biomes.", "SECTIONS:", "(These are all optional, but some do rely on others. `height gen` and `block pop` require `chunk gen`)", "`noise gen` = Generate the base terrain of a chunk.", "`surface gen` = Generate the surface above the base terrain of the chunk.", "`chunk gen` = A combination of noise and surface gen (Cannot be used WITH noise/surface gen).", "`biome gen` = Generate the biomes to be placed in a chunk.", "`height gen` = Tell Minecraft where the highest block in a chunk is for generating structures.", "`block pop` = Used to decorate after initial surface is generated (Structures can be placed during this stage).", "NOTES:", "- `world-creator` needs to be enabled in the config", "- Please see the [**Chunk Generator**](https://github.com/ShaneBeee/SkBee/wiki/Chunk-Generator) wiki for further details."})
@Examples(value={"register chunk generator with id \"mars\":", "\tvanilla decor: false", "\tvanilla caves: false", "\tvanilla structures: false", "\tvanilla mobs: false", "\tchunk gen:", "\t\tloop 16 times:", "\t\t\tloop 16 times:", "\t\t\t\tset {_x} to (loop-number-1) - 1", "\t\t\t\tset {_z} to (loop-number-2) - 1", "", "\t\t\t\t# This is just an expression I created with reflect to give you an idea how it can work", "\t\t\t\tset {_y} to biome noise at vector({_x} + (chunkdata chunk x * 16), 1, {_z} + (chunkdata chunk z * 16))", "\t\t\t\t# Fill blocks from 0 to y level with concrete", "\t\t\t\tset chunkdata blocks within vector({_x}, 0, {_z}) and vector({_x}, {_y}, {_z}) to red_concrete[]", "\t\t\t\t# Set the surface layer to concrete powder", "\t\t\t\tset chunkdata block at vector({_x}, {_y}, {_z}) to red_concrete_powder[]", "", "\tbiome gen:", "\t\t# Set our biome to something mars like", "\t\tset chunkdata biome to crimson forest"})
@Since(value={"3.5.0"})
public class StructChunkGen
extends Structure {
    private static final Structure.Priority PRIORITY = new Structure.Priority(450);
    private Literal<String> id;
    private EntryContainer entryContainer;
    private Expression<Boolean> vanillaDecor;
    private Expression<Boolean> vanillaCaves;
    private Expression<Boolean> vanillaStructures;
    private Expression<Boolean> vanillaMobs;
    private Trigger noiseGenSection;
    private Trigger surfaceGenSection;
    private Trigger chunkGenSection;
    private Trigger biomeGenSection;
    private Trigger heightGenSection;
    private Trigger blockPopSection;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, EntryContainer entryContainer) {
        this.id = args[0];
        if (entryContainer == null) {
            return false;
        }
        this.entryContainer = entryContainer;
        return true;
    }

    public boolean preLoad() {
        SectionNode blockPopNode;
        SectionNode heightNode;
        SectionNode biomeNode;
        SectionNode chunkNode;
        SectionNode surfaceNode;
        this.vanillaDecor = (Expression)this.entryContainer.getOptional("vanilla decor", false);
        this.vanillaCaves = (Expression)this.entryContainer.getOptional("vanilla caves", false);
        this.vanillaStructures = (Expression)this.entryContainer.getOptional("vanilla structures", false);
        this.vanillaMobs = (Expression)this.entryContainer.getOptional("vanilla mobs", false);
        Script currentScript = this.getParser().getCurrentScript();
        SectionNode noiseNode = (SectionNode)this.entryContainer.getOptional("noise gen", SectionNode.class, false);
        if (noiseNode != null) {
            this.getParser().setCurrentEvent("noise gen section", new Class[]{ChunkGenEvent.class});
            this.noiseGenSection = new Trigger(currentScript, "noise gen", (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)noiseNode));
        }
        if ((surfaceNode = (SectionNode)this.entryContainer.getOptional("surface gen", SectionNode.class, false)) != null) {
            this.getParser().setCurrentEvent("surface gen section", new Class[]{ChunkGenEvent.class});
            this.surfaceGenSection = new Trigger(currentScript, "surface gen", (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)surfaceNode));
        }
        if ((chunkNode = (SectionNode)this.entryContainer.getOptional("chunk gen", SectionNode.class, false)) != null) {
            if (noiseNode != null) {
                Skript.error((String)"Cannot use a 'chunk gen' section with a 'noise gen' section");
                return false;
            }
            if (surfaceNode != null) {
                Skript.error((String)"Cannot use a 'chunk gen' section with a 'surface gen' section");
                return false;
            }
            this.getParser().setCurrentEvent("chunk gen section", new Class[]{ChunkGenEvent.class});
            this.chunkGenSection = new Trigger(currentScript, "chunk gen", (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)chunkNode));
        }
        if ((biomeNode = (SectionNode)this.entryContainer.getOptional("biome gen", SectionNode.class, false)) != null) {
            this.getParser().setCurrentEvent("biome gen section", new Class[]{BiomeGenEvent.class});
            this.biomeGenSection = new Trigger(currentScript, "biome gen", (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)biomeNode));
        }
        if ((heightNode = (SectionNode)this.entryContainer.getOptional("height gen", SectionNode.class, false)) != null) {
            this.getParser().setCurrentEvent("height gen section", new Class[]{HeightGenEvent.class});
            this.heightGenSection = new Trigger(currentScript, "height gen", (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)heightNode));
        }
        if ((blockPopNode = (SectionNode)this.entryContainer.getOptional("block pop", SectionNode.class, false)) != null) {
            this.getParser().setCurrentEvent("block pop section", new Class[]{BlockPopulateEvent.class});
            this.blockPopSection = new Trigger(currentScript, "block pop", (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)blockPopNode));
        }
        return true;
    }

    public boolean load() {
        BiomeGenerator biomeGenerator;
        ChunkGen chunkGen = ChunkGenManager.registerOrGetGenerator((String)this.id.getSingle(), this.biomeGenSection != null);
        ChunkGenerator chunkGenerator = chunkGen.getChunkGenerator();
        if (chunkGenerator != null) {
            boolean vanillaDecor = this.vanillaDecor != null && this.vanillaDecor.getOptionalSingle(null).orElse(false) != false;
            chunkGenerator.setVanillaDecor(vanillaDecor);
            boolean vanillaCaves = this.vanillaCaves != null && this.vanillaCaves.getOptionalSingle(null).orElse(false) != false;
            chunkGenerator.setVanillaCaves(vanillaCaves);
            boolean vanillaStructures = this.vanillaStructures != null && this.vanillaStructures.getOptionalSingle(null).orElse(false) != false;
            chunkGenerator.setVanillaStructures(vanillaStructures);
            boolean vanillaMobs = this.vanillaMobs != null && this.vanillaMobs.getOptionalSingle(null).orElse(false) != false;
            chunkGenerator.setVanillaMobs(vanillaMobs);
            chunkGenerator.setNoiseGenTrigger(this.noiseGenSection);
            chunkGenerator.setSurfaceGenTrigger(this.surfaceGenSection);
            chunkGenerator.setChunkGenTrigger(this.chunkGenSection);
            chunkGenerator.setBlockPopTrigger(this.blockPopSection);
            chunkGenerator.setHeightGenTrigger(this.heightGenSection);
        }
        if (this.biomeGenSection != null && (biomeGenerator = chunkGen.getBiomeGenerator()) != null) {
            biomeGenerator.setTrigger(this.biomeGenSection);
        }
        return true;
    }

    public Structure.Priority getPriority() {
        return PRIORITY;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "register chunk generator with id " + this.id.toString(e, d);
    }

    static {
        SimpleEntryValidator builder = SimpleEntryValidator.builder();
        builder.addOptionalEntry("vanilla decor", Boolean.class);
        builder.addOptionalEntry("vanilla caves", Boolean.class);
        builder.addOptionalEntry("vanilla structures", Boolean.class);
        builder.addOptionalEntry("vanilla mobs", Boolean.class);
        builder.addOptionalSection("noise gen");
        builder.addOptionalSection("surface gen");
        builder.addOptionalSection("chunk gen");
        builder.addOptionalSection("biome gen");
        builder.addOptionalSection("height gen");
        builder.addOptionalSection("block pop");
        Skript.registerStructure(StructChunkGen.class, (EntryValidator)builder.build(), (String[])new String[]{"register chunk generator with id %string%"});
    }
}

