/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="ItemComponent - Has Components")
@Description(value={"Check if an item has a specific item component.", "See [Data Component Format](https://minecraft.wiki/w/Data_component_format) on McWiki for more details."})
@Examples(value={"if player's tool has item component minecraft:tooltip_display:", "if {_i} doesnt have data component minecraft:glider:", "set {_a} to whether player's tool has max_damage item component"})
@Since(value={"3.11.0"})
public class CondHasComponent
extends Condition {
    private Expression<Object> items;
    private Expression<DataComponentType> dataComponentTypes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        this.dataComponentTypes = exprs[1];
        this.setNegated(parseResult.hasTag("neg"));
        return true;
    }

    public boolean check(Event event) {
        return this.items.check(event, object -> {
            ItemStack itemStack = ItemUtils.getItemStackFromObjects(object);
            if (itemStack != null) {
                return this.dataComponentTypes.check(event, arg_0 -> ((ItemStack)itemStack).hasData(arg_0), this.isNegated());
            }
            return false;
        });
    }

    public String toString(Event e, boolean d) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(e, d);
        builder.append(this.items);
        builder.append((Object)(this.isNegated() ? "doesn't have" : "has"));
        builder.append(this.dataComponentTypes);
        return builder.toString();
    }

    static {
        Skript.registerCondition(CondHasComponent.class, (String[])new String[]{"%itemstacks/itemtypes/slots% (has|neg:doesn't have) (item|data) component %datacomponenttypes%", "%itemstacks/itemtypes/slots% (has|neg:doesn't have) %datacomponenttypes% (item|data) component"});
    }
}

