/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.registry.KeyUtils;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.elements.itemcomponent.sections.SecConsumableComponent;
import com.shanebeestudios.skbee.elements.itemcomponent.sections.SecDeathProtectionComponent;
import com.shanebeestudios.skbee.elements.itemcomponent.sections.SecPotionContentsComponent;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.DeathProtection;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import java.util.ArrayList;
import net.kyori.adventure.key.Key;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@Name(value="ItemComponent - Apply Effects")
@Description(value={"Used to apply potion/consume effects in a potion contents's `custom_effects` section, death protection's' `death_effects` section and consumable's `on_consume_effects` section.", "", "**Patterns**:", "- `%potioneffects%` = Used to apply a potion effect in a potion contents section.", "- `%potioneffects% with probability %-number%` = Used to apply a potion/consume effect in a death protection/consumable section.", "- `remove effects %potioneffecttypes/typedkeys%` = Used to apply a `remove effects` consume effect in a death protection/consumable section.", "- `clear all effects` = Used to apply a `clear all effects` consume effect in a death protection/consumable section.", "- `teleport randomly within [[a] diameter [of]] %number% [blocks|meters]` = Used to apply a `teleport randomly` consume effect in a death protection/consumable section.", "- `play sound %string/typedkey%` - Used to apply a `play sound` consume effect in a death protection/consumable section."})
@Examples(value={"See examples of the respective sections that use this effect."})
@Since(value={"3.8.1"})
public class EffApplyToComponent
extends Effect {
    private int pattern;
    private Expression<?> effects;
    private Expression<?> potionEffectTypes;
    private Expression<Number> numberExp;
    private Expression<?> sound;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 0 && !this.getParser().isCurrentEvent(SecPotionContentsComponent.PotionContentsEvent.class)) {
            Skript.error((String)"'apply effect -> potion effects' can only be used in a potion contents section.");
            return false;
        }
        if (this.pattern > 0 && !this.getParser().isCurrentEvent(new Class[]{SecConsumableComponent.ConsumeEffectsEvent.class, SecDeathProtectionComponent.DeathProtectionEvent.class})) {
            Skript.error((String)"'apply effect' can only be used in a consumeable/deathprotection sections.");
            return false;
        }
        if (this.pattern < 2) {
            this.effects = exprs[0];
        }
        if (this.pattern == 2) {
            this.potionEffectTypes = exprs[0];
        }
        if (this.pattern == 1) {
            this.numberExp = exprs[1];
        } else if (this.pattern == 4) {
            this.numberExp = exprs[0];
        }
        if (this.pattern == 5) {
            this.sound = exprs[0];
        }
        return true;
    }

    protected void execute(Event event) {
        if (event instanceof SecPotionContentsComponent.PotionContentsEvent) {
            SecPotionContentsComponent.PotionContentsEvent potionEvent = (SecPotionContentsComponent.PotionContentsEvent)event;
            PotionContents.Builder builder = potionEvent.getPotionContentsBuilder();
            for (Object object : this.effects.getArray(event)) {
                if (!(object instanceof PotionEffect)) continue;
                PotionEffect potionEffect = (PotionEffect)object;
                builder.addCustomEffect(potionEffect);
            }
        } else if (event instanceof SecConsumableComponent.ConsumeEffectsEvent) {
            SecConsumableComponent.ConsumeEffectsEvent consumeEvent = (SecConsumableComponent.ConsumeEffectsEvent)event;
            Consumable.Builder builder = consumeEvent.getConsumableBuilder();
            ConsumeEffect effect = this.createEffect(event);
            if (effect != null) {
                builder.addEffect(effect);
            }
        } else if (event instanceof SecDeathProtectionComponent.DeathProtectionEvent) {
            SecDeathProtectionComponent.DeathProtectionEvent deathEvent = (SecDeathProtectionComponent.DeathProtectionEvent)event;
            DeathProtection.Builder builder = deathEvent.getDeathProtectionBuilder();
            ConsumeEffect effect = this.createEffect(event);
            if (effect != null) {
                builder.addEffect(effect);
            }
        }
    }

    private ConsumeEffect createEffect(Event event) {
        return switch (this.pattern) {
            case 1 -> {
                float prob = this.numberExp != null ? ((Number)this.numberExp.getOptionalSingle(event).orElse(Float.valueOf(1.0f))).floatValue() : 1.0f;
                ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                for (Object object : this.effects.getArray(event)) {
                    if (!(object instanceof PotionEffect)) continue;
                    PotionEffect potionEffect = (PotionEffect)object;
                    effects.add(potionEffect);
                }
                yield ConsumeEffect.applyStatusEffects(effects, (float)Math.clamp(prob, 0.0f, 1.0f));
            }
            case 2 -> {
                ArrayList<TypedKey> keys = new ArrayList<TypedKey>();
                for (Object object : this.potionEffectTypes.getArray(event)) {
                    TypedKey typedKey;
                    if (object instanceof PotionEffectType) {
                        PotionEffectType potionEffectType = (PotionEffectType)object;
                        keys.add(TypedKey.create((RegistryKey)RegistryKey.MOB_EFFECT, (Key)potionEffectType.key()));
                        continue;
                    }
                    if (!(object instanceof TypedKey) || (typedKey = (TypedKey)object).registryKey() != RegistryKey.MOB_EFFECT) continue;
                    keys.add(typedKey);
                }
                RegistryKeySet keySet = RegistrySet.keySet((RegistryKey)RegistryKey.MOB_EFFECT, keys);
                yield ConsumeEffect.removeEffects((RegistryKeySet)keySet);
            }
            case 3 -> ConsumeEffect.clearAllStatusEffects();
            case 4 -> {
                float diameter = this.numberExp != null ? ((Number)this.numberExp.getOptionalSingle(event).orElse(Float.valueOf(16.0f))).floatValue() : 16.0f;
                yield ConsumeEffect.teleportRandomlyEffect((float)diameter);
            }
            case 5 -> {
                TypedKey typedKey;
                Key key = null;
                Object object = this.sound.getSingle(event);
                if (object instanceof String) {
                    String string = (String)object;
                    key = KeyUtils.getKey(string);
                } else if (object instanceof TypedKey && (typedKey = (TypedKey)object).registryKey() == RegistryKey.SOUND_EVENT) {
                    key = typedKey.key();
                }
                if (key == null) {
                    key = Key.key((String)"block.stone.break");
                }
                yield ConsumeEffect.playSoundConsumeEffect((Key)key);
            }
            default -> null;
        };
    }

    public String toString(Event e, boolean d) {
        return switch (this.pattern) {
            case 0 -> "apply -> " + this.effects.toString(e, d);
            case 1 -> "apply " + this.effects.toString(e, d) + " with duration " + this.numberExp.toString(e, d);
            case 2 -> "remove effects " + this.potionEffectTypes.toString(e, d);
            case 3 -> "clear all effects";
            case 4 -> "teleport randomly" + (String)(this.numberExp != null ? " within diameter of " + this.numberExp.toString(e, d) : "");
            case 5 -> "play sound " + this.sound.toString(e, d);
            default -> null;
        };
    }

    static {
        Skript.registerEffect(EffApplyToComponent.class, (String[])new String[]{"apply -> %potioneffects%", "apply -> %potioneffects% with probability %-number%", "apply -> remove effects %potioneffecttypes/typedkeys%", "apply -> clear all effects", "apply -> teleport randomly within [[a] diameter [of]] %number% [blocks|meters]", "apply -> play sound %string/typedkey%"});
    }
}

