/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Intangible Projectile")
@Description(value={"If applied, a projectile item can't be picked up by a player when fired, except in creative mode.", "If the item does not have this component, it will return null, not false.", "See [**Intangible Projectile Component**](https://minecraft.wiki/w/Data_component_format#intangible_projectile) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Changers**:", "- `set` = If set to true, the component will be applied, otherwise removed.", "- `reset` = Reset back to default state.", "- `delete` = Will delete any value (vanilla or not)."})
@Examples(value={"set intangible projectile component of player's tool to true", "delete intangible projectile component of player's tool", "reset intangible projectile component of player's tool"})
@Since(value={"3.8.0"})
public class ExprIntangibleProjectileComponent
extends SimplePropertyExpression<Object, Boolean> {
    @Nullable
    public Boolean convert(Object from) {
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.INTANGIBLE_PROJECTILE)) {
            return true;
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
            case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        boolean bl;
        Object object;
        if (delta != null && (object = delta[0]) instanceof Boolean) {
            Boolean b = (Boolean)object;
            bl = b;
        } else {
            bl = false;
        }
        boolean glider = bl;
        ItemUtils.modifyItems(this.getExpr().getArray(event), itemStack -> {
            if (mode == Changer.ChangeMode.SET) {
                if (glider) {
                    itemStack.setData(DataComponentTypes.INTANGIBLE_PROJECTILE);
                } else {
                    itemStack.unsetData((DataComponentType)DataComponentTypes.INTANGIBLE_PROJECTILE);
                }
            } else if (mode == Changer.ChangeMode.DELETE) {
                itemStack.unsetData((DataComponentType)DataComponentTypes.INTANGIBLE_PROJECTILE);
            } else if (mode == Changer.ChangeMode.RESET) {
                itemStack.resetData((DataComponentType)DataComponentTypes.INTANGIBLE_PROJECTILE);
            }
        });
    }

    protected String getPropertyName() {
        return "intangible projectile component";
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    static {
        ExprIntangibleProjectileComponent.register(ExprIntangibleProjectileComponent.class, Boolean.class, (String)"intangible projectile component", (String)"itemstacks/itemtypes/slots");
    }
}

