/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.Math2;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - repair cost component")
@Description(value={"The number of experience levels to add to the base level cost when repairing, combining, or renaming this item with an anvil.", "Must be a non-negative integer, defaults to 0."})
@Examples(value={"set repair cost component of player's tool to 3", "add 2 to repair cost component of player's tool", "subtract 1 from repair cost component of player's tool", "reset repair cost component of player's tool", "delete repair cost component of {_item}", "if repair cost component of player's tool > 0:"})
@Since(value={"3.6.0"})
public class ExprRepairCost
extends SimplePropertyExpression<Object, Number> {
    @Nullable
    public Number convert(Object from) {
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.REPAIR_COST)) {
            return (Number)itemStack.getData(DataComponentTypes.REPAIR_COST);
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int n;
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            n = num.intValue();
        } else {
            n = 0;
        }
        int cost = n;
        ItemUtils.modifyItems(this.getExpr().getArray(event), itemStack -> {
            if (mode == Changer.ChangeMode.RESET) {
                itemStack.resetData((DataComponentType)DataComponentTypes.REPAIR_COST);
            } else if (mode == Changer.ChangeMode.DELETE) {
                itemStack.unsetData((DataComponentType)DataComponentTypes.REPAIR_COST);
            } else {
                int changeValue = cost;
                if (mode == Changer.ChangeMode.ADD && itemStack.hasData((DataComponentType)DataComponentTypes.REPAIR_COST)) {
                    changeValue += ((Integer)itemStack.getData(DataComponentTypes.REPAIR_COST)).intValue();
                } else if (mode == Changer.ChangeMode.REMOVE && itemStack.hasData((DataComponentType)DataComponentTypes.REPAIR_COST)) {
                    changeValue = (Integer)itemStack.getData(DataComponentTypes.REPAIR_COST) - changeValue;
                }
                itemStack.setData(DataComponentTypes.REPAIR_COST, (Object)Math2.fit((int)0, (int)changeValue, (int)Integer.MAX_VALUE));
            }
        });
    }

    @NotNull
    protected String getPropertyName() {
        return "repair cost component";
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprRepairCost.register(ExprRepairCost.class, Number.class, (String)"repair cost component", (String)"itemstacks/itemtypes/slots");
    }
}

