/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.Util;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Repairable;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Repairable")
@Description(value={"Represents the items/tags that will be used to repair an item in an anvil.", "See [**Repairable Component**](https://minecraft.wiki/w/Data_component_format#repairable) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Patterns**:", "`repairable items` = A list of items that are used.", "`repairable tag` = A single Minecraft item tag that is used.", "", "**Changers**:", "- `set` = Set the items/tag to allow for repairing.", "- `reset` = Reset back to default state.", "- `delete` = Will delete any value (vanilla or not)."})
@Examples(value={"set {_items::*} to repairable items of player's tool", "set {_tag} to repairable tag of player's tool", "set repairable items of player's tool to diamond, iron ingot and emerald", "set repairable tag of player's tool to minecraft item tag \"diamond_tool_materials\"", "delete repairable tag of player's tool", "reset repairable tag of player's tool"})
@Since(value={"3.8.0"})
public class ExprRepairableComponent
extends SimpleExpression<Object> {
    private static final RegistryAccess REGISTRY_ACCESS = RegistryAccess.registryAccess();
    private static final Registry<ItemType> ITEM_REGISTRY = REGISTRY_ACCESS.getRegistry(RegistryKey.ITEM);
    private Expression<Object> items;
    private boolean tag;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        this.tag = matchedPattern == 1;
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        ArrayList<Object> repairables = new ArrayList<Object>();
        for (Object object : this.items.getArray(event)) {
            Repairable data;
            ItemStack itemStack = ItemUtils.getItemStackFromObjects(object);
            if (itemStack == null || !itemStack.hasData((DataComponentType)DataComponentTypes.REPAIRABLE) || (data = (Repairable)itemStack.getData(DataComponentTypes.REPAIRABLE)) == null) continue;
            RegistryKeySet types = data.types();
            if (this.tag && types instanceof Tag) {
                Tag paperTag = (Tag)types;
                Key key = paperTag.tagKey().key();
                NamespacedKey nKey = Util.getNamespacedKey(key.toString(), false);
                if (nKey == null) continue;
                org.bukkit.Tag bukkitTag = Bukkit.getTag((String)"items", (NamespacedKey)nKey, Material.class);
                repairables.add(bukkitTag);
                continue;
            }
            if (this.tag) continue;
            for (TypedKey type : types) {
                ItemType itemType = (ItemType)ITEM_REGISTRY.get(type);
                assert (itemType != null);
                Material material = itemType.asMaterial();
                if (material == null) continue;
                repairables.add(new ch.njol.skript.aliases.ItemType(material));
            }
        }
        return repairables.toArray(this.tag ? new org.bukkit.Tag[]{} : new ch.njol.skript.aliases.ItemType[]{});
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{ch.njol.skript.aliases.ItemType[].class, org.bukkit.Tag.class});
            case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Repairable repairable = null;
        if (delta != null) {
            Object object = delta[0];
            if (object instanceof org.bukkit.Tag) {
                org.bukkit.Tag bukkitTag = (org.bukkit.Tag)object;
                TagKey itemTypeTagKey = TagKey.create((RegistryKey)RegistryKey.ITEM, (Key)bukkitTag.key());
                Tag tag = ITEM_REGISTRY.getTag(itemTypeTagKey);
                repairable = Repairable.repairable((RegistryKeySet)tag);
            } else {
                ArrayList<TypedKey> keys = new ArrayList<TypedKey>();
                for (Object object2 : delta) {
                    if (!(object2 instanceof ch.njol.skript.aliases.ItemType)) continue;
                    ch.njol.skript.aliases.ItemType itemType = (ch.njol.skript.aliases.ItemType)object2;
                    TypedKey typedKey = TypedKey.create((RegistryKey)RegistryKey.ITEM, (Key)itemType.getMaterial().key());
                    keys.add(typedKey);
                }
                if (!keys.isEmpty()) {
                    RegistryKeySet registryKeySet = RegistrySet.keySet((RegistryKey)RegistryKey.ITEM, keys);
                    repairable = Repairable.repairable((RegistryKeySet)registryKeySet);
                }
            }
        }
        ItemComponentUtils.modifyComponent(this.items.getArray(event), mode, DataComponentTypes.REPAIRABLE, repairable);
    }

    public boolean isSingle() {
        return this.tag;
    }

    public Class<?> getReturnType() {
        return this.tag ? org.bukkit.Tag.class : ch.njol.skript.aliases.ItemType.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(event, debug);
        builder.append((Object)"repairable");
        builder.append((Object)(this.tag ? "tag" : "items"));
        builder.append(new Object[]{"of", this.items});
        return builder.toString();
    }

    static {
        Skript.registerExpression(ExprRepairableComponent.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"repairable [component] items of %itemstacks/itemtypes/slots%", "repairable [component] tag of %itemstacks/slots%"});
    }
}

