/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.registry.KeyUtils;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import net.kyori.adventure.key.Key;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Tooltip Style")
@Description(value={"The key of the custom sprites for the tooltip background and frame which references textures.", "See [**Tooltip Style Component**](https://minecraft.wiki/w/Data_component_format#tooltip_style) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Changers**:", "- `set` = Set the key of the texture to use.", "- `reset` = Reset back to default state.", "- `delete` = Will delete any value (vanilla or not)."})
@Examples(value={"set tooltip style of {_item} to \"my_pack:some_style\"", "delete tooltip style of player's tool", "reset tooltip style of player's tool"})
@Since(value={"3.8.0"})
public class ExprTooltipStyleComponent
extends SimplePropertyExpression<Object, String> {
    @Nullable
    public String convert(Object from) {
        Key data;
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.TOOLTIP_STYLE) && (data = (Key)itemStack.getData(DataComponentTypes.TOOLTIP_STYLE)) != null) {
            return data.toString();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
            case Changer.ChangeMode.REMOVE, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        String s;
        Object object;
        String string = delta != null && (object = delta[0]) instanceof String ? (s = (String)object) : null;
        Key key = KeyUtils.getKey(string);
        ItemComponentUtils.modifyComponent(this.getExpr().getArray(event), mode, DataComponentTypes.TOOLTIP_STYLE, key);
    }

    protected String getPropertyName() {
        return "tooltip style";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprTooltipStyleComponent.register(ExprTooltipStyleComponent.class, String.class, (String)"tool[ ]tip style [component]", (String)"itemstacks/itemtypes/slots");
    }
}

