/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.UseRemainder;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Use Remainder")
@Description(value={"If present, replaces the item with a remainder item if its stack count has decreased after use.", "Requires Paper 1.21.3+", "See [**Use Remainder Component**](https://minecraft.wiki/w/Data_component_format#use_remainder) on McWiki for more details.", "", "**Changers**:", "- `set` = Set the item to be replaced with.", "- `reset` = Reset back to default state.", "- `delete` = Will delete any value (vanilla or not)."})
@Examples(value={"set use remainder of player's tool to 1 of glass bottle", "delete use remainder of {_item}", "reset use remainder of {_item}"})
@Since(value={"3.8.0"})
public class ExprUseRemainderComponent
extends SimplePropertyExpression<Object, ItemStack> {
    @Nullable
    public ItemStack convert(Object from) {
        UseRemainder data;
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.USE_REMAINDER) && (data = (UseRemainder)itemStack.getData(DataComponentTypes.USE_REMAINDER)) != null) {
            return data.transformInto();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{ItemStack.class});
            case Changer.ChangeMode.RESET, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        ItemStack is;
        Object object;
        ItemStack transformInto = delta != null && (object = delta[0]) instanceof ItemStack ? (is = (ItemStack)object) : null;
        UseRemainder remainder = transformInto != null ? UseRemainder.useRemainder(transformInto) : null;
        ItemComponentUtils.modifyComponent(this.getExpr().getArray(event), mode, DataComponentTypes.USE_REMAINDER, remainder);
    }

    protected String getPropertyName() {
        return "use remainder";
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    static {
        ExprUseRemainderComponent.register(ExprUseRemainderComponent.class, ItemStack.class, (String)"use remainder [component]", (String)"itemstacks/itemtypes/slots");
    }
}

