/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.registry.RegistryUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import io.papermc.paper.block.BlockPredicate;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemAdventurePredicate;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - Adventure Predicate Apply")
@Description(value={"Apply an adventure can break/can place on predicate to items.", "Requires Paper 1.21.3+", "See [**Can Break**](https://minecraft.wiki/w/Data_component_format#can_break)/[**Can Place On**](https://minecraft.wiki/w/Data_component_format#can_place_on) components on McWiki for more info.", "", "**Entries**:", "- `blocks` = The blocks this item can place on/can break. (Accepts ItemTypes, BlockDatas, Tags, TagKeys and RegistryKeySets(soon\u2122))"})
@Examples(value={"apply can break adventure predicate to player's tool:", "\tblocks: grass block, dirt, stone, gravel", "", "apply can break adventure predicate to player's tool:", "\tblocks: minecraft block tag \"minecraft:mineable/pickaxe\"", "", "apply can place on adventure predicate to player's tool:", "\tblocks: minecraft block tag \"minecraft:logs\""})
@Since(value={"3.8.0"})
public class SecAdventureComponent
extends Section {
    private static final EntryValidator VALIDATOR;
    private Expression<?> items;
    private Expression<?> blocks;
    private DataComponentType.Valued<ItemAdventurePredicate> dataType;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (sectionNode == null) {
            return false;
        }
        EntryContainer validate = VALIDATOR.validate(sectionNode);
        if (validate == null) {
            return false;
        }
        this.items = exprs[0];
        this.blocks = (Expression)validate.getOptional("blocks", Object.class, false);
        this.dataType = parseResult.hasTag("place") ? DataComponentTypes.CAN_PLACE_ON : DataComponentTypes.CAN_BREAK;
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        ArrayList<TypedKey> blockTypes = new ArrayList<TypedKey>();
        ItemAdventurePredicate.Builder builder = ItemAdventurePredicate.itemAdventurePredicate();
        for (Object object : this.blocks.getArray(event)) {
            Registry registry;
            TagKey tagKey;
            RegistryKeySet keySet;
            TypedKey blockType;
            if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                blockType = TypedKey.create((RegistryKey)RegistryKey.BLOCK, (Key)itemType.getMaterial().key());
                if (blockTypes.contains(blockType)) continue;
                blockTypes.add(blockType);
                continue;
            }
            if (object instanceof BlockData) {
                BlockData blockData = (BlockData)object;
                blockType = TypedKey.create((RegistryKey)RegistryKey.BLOCK, (Key)blockData.getMaterial().key());
                if (blockTypes.contains(blockType)) continue;
                blockTypes.add(blockType);
                continue;
            }
            if (object instanceof Tag) {
                Tag tag = (Tag)object;
                RegistryKeySet keySet2 = RegistryUtils.getKeySet(tag, RegistryKey.BLOCK);
                builder.addPredicate(BlockPredicate.predicate().blocks(keySet2).build());
                continue;
            }
            if (object instanceof RegistryKeySet && (keySet = (RegistryKeySet)object).registryKey() == RegistryKey.BLOCK) {
                builder.addPredicate(BlockPredicate.predicate().blocks(keySet).build());
                continue;
            }
            if (!(object instanceof TagKey) || (tagKey = (TagKey)object).registryKey() != RegistryKey.BLOCK || !(registry = RegistryUtils.getRegistry(RegistryKey.BLOCK)).hasTag(tagKey)) continue;
            builder.addPredicate(BlockPredicate.predicate().blocks((RegistryKeySet)registry.getTag(tagKey)).build());
        }
        if (!blockTypes.isEmpty()) {
            RegistryKeySet keySet = RegistrySet.keySet((RegistryKey)RegistryKey.BLOCK, blockTypes);
            builder.addPredicate(BlockPredicate.predicate().blocks(keySet).build());
        }
        ItemAdventurePredicate predicate = (ItemAdventurePredicate)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(this.dataType, (Object)predicate));
        return super.walk(event, false);
    }

    public String toString(@Nullable Event e, boolean d) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(e, d);
        builder.append((Object)"apply");
        builder.append((Object)(this.dataType == DataComponentTypes.CAN_PLACE_ON ? "can place on" : "can break"));
        builder.append(new Object[]{"adventure predicate to", this.items});
        return builder.toString();
    }

    static {
        Class[] classes = (Class[])CollectionUtils.array((Object[])new Class[]{ItemType.class, BlockData.class, Tag.class, RegistryKeySet.class, TagKey.class});
        VALIDATOR = SimpleEntryValidator.builder().addRequiredEntry("blocks", classes).build();
        Skript.registerSection(SecAdventureComponent.class, (String[])new String[]{"apply (place:can place on|can break) [adventure] predicate to %itemstacks/itemtypes/slots%"});
    }
}

