/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Color;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - CustomModelData Component Apply")
@Description(value={"Apply a custom model data component to items.", "Requires Paper 1.21.4+", "See [**CustomModelData Component**](https://minecraft.wiki/w/Data_component_format#custom_model_data) on McWiki for more info.", "", "**Entries**:", "- `floats` = A list of numbers.", "- `flags` = A list of booleans (true/false).", "- `strings` = A list of strings.", "- `colors` = A list of colors."})
@Examples(value={"apply custom model data to player's tool:", "\tfloats: 1, 2, 3, 4, 5", "\tstrings: \"hello\", \"yippee\"", "\tflags: true, true, true, false", "\tcolors: blue, green, rgb(1,1,1)"})
@Since(value={"3.8.0"})
public class SecCustomModelDataComponent
extends Section {
    private static final EntryValidator VALIDATOR = SimpleEntryValidator.builder().addOptionalEntry("floats", Number.class).addOptionalEntry("flags", Boolean.class).addOptionalEntry("strings", String.class).addOptionalEntry("colors", Color.class).build();
    private Expression<?> items;
    private Expression<Number> floats;
    private Expression<Boolean> flags;
    private Expression<String> strings;
    private Expression<Color> colors;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!Util.IS_RUNNING_MC_1_21_4) {
            Skript.error((String)"CustomModelData with fields requires Minecraft 1.21.4+");
            return false;
        }
        EntryContainer validate = VALIDATOR.validate(sectionNode);
        if (validate == null) {
            return false;
        }
        this.items = exprs[0];
        this.floats = (Expression)validate.getOptional("floats", false);
        this.flags = (Expression)validate.getOptional("flags", false);
        this.strings = (Expression)validate.getOptional("strings", false);
        this.colors = (Expression)validate.getOptional("colors", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        CustomModelData.Builder builder = CustomModelData.customModelData();
        if (this.floats != null) {
            for (Number number : (Number[])this.floats.getArray(event)) {
                builder.addFloat(number.floatValue());
            }
        }
        if (this.flags != null) {
            for (Boolean bool : (Boolean[])this.flags.getArray(event)) {
                builder.addFlag(bool.booleanValue());
            }
        }
        if (this.strings != null) {
            for (String string : (String[])this.strings.getArray(event)) {
                builder.addString(string);
            }
        }
        if (this.colors != null) {
            for (Color color : (Color[])this.colors.getArray(event)) {
                builder.addColor(color.asBukkitColor());
            }
        }
        CustomModelData customModelData = (CustomModelData)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)customModelData));
        return super.walk(event, false);
    }

    public String toString(Event e, boolean d) {
        return "apply custom model data component to " + this.items.toString(e, d);
    }

    static {
        Skript.registerSection(SecCustomModelDataComponent.class, (String[])new String[]{"apply custom model data [component] to %itemstacks/itemtypes/slots%"});
    }
}

