/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.registry.KeyUtils;
import com.shanebeestudios.skbee.api.registry.RegistryUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Tag;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - Equippable Component Apply")
@Description(value={"Apply an equippable component to any item so it can be equipped in the specified slot.", "Requires Paper 1.21.3+", "See [**Equippable Component**](https://minecraft.wiki/w/Data_component_format#equippable) on McWiki for more info.", "", "**Entries**:", "- `slot` = The slot the item can be put on (See Equipment Slot).", "- `equip_sound` = The sound to be played when equipped. [Optional]", "- `asset_id` = The key of the equipment model to use when equipped. [Optional]", "- `allowed_entities` = A list of entity types or a Minecraft entity tag that can equip this item. [Optional]", "- `dispensable` = Whether the item can be dispensed by using a dispenser. Defaults to true. [Optional]", "- `swappable` = Whether the item can be equipped into the relevant slot by right-clicking. Defaults to true. [Optional]", "- `damage_on_hurt` = Whether this item is damaged when the wearing entity is damaged. Defaults to true. [Optional]", "- `camera_overlay` = The key of the overlay texture to use when equipped. [Optional]"})
@Examples(value={"apply equippable component to {_item}:", "\tslot: hand_slot", "\tequip_sound: \"entity.player.burp\"", "\tasset_id: \"my_pack:some_asset\"", "\tallowed_entities: player, evoker, zombie # Shown as list of entity types.", "\tallowed_entities: minecraft entity tag \"undead\" # Shown as Minecraft entity tag", "\tdispensable: false", "\tswappable: true", "\tdamage_on_hurt: true", "\tcamera_overlay: \"my_pack:some_overlay\""})
@Since(value={"3.8.0"})
public class SecEquippableComponent
extends Section {
    private static final EntryValidator VALIDATOR;
    private Expression<Object> items;
    private Expression<EquipmentSlot> equipmentSlot;
    private Expression<String> equipSound;
    private Expression<String> assetId;
    private Expression<?> allowedEntities;
    private Expression<Boolean> dispensable;
    private Expression<Boolean> swappable;
    private Expression<Boolean> damageOnHurt;
    private Expression<String> cameraOverlay;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> triggerItems) {
        this.items = exprs[0];
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.equipmentSlot = (Expression)container.getOptional("slot", false);
        this.equipSound = (Expression)container.getOptional("equip_sound", false);
        this.assetId = (Expression)container.getOptional("asset_id", false);
        this.allowedEntities = (Expression)container.getOptional("allowed_entities", false);
        this.dispensable = (Expression)container.getOptional("dispensable", false);
        this.swappable = (Expression)container.getOptional("swappable", false);
        this.damageOnHurt = (Expression)container.getOptional("damage_on_hurt", false);
        this.cameraOverlay = (Expression)container.getOptional("camera_overlay", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Key key;
        String overlay;
        Object[] key2;
        String assetId;
        Key key3;
        if (this.equipmentSlot == null) {
            return null;
        }
        EquipmentSlot slot = this.equipmentSlot.getOptionalSingle(event).orElse(EquipmentSlot.HEAD);
        Equippable.Builder builder = Equippable.equippable((EquipmentSlot)slot);
        if (this.equipSound != null && (key3 = KeyUtils.getKey(this.equipSound.getOptionalSingle(event).orElse("item.armor.equip_generic"))) != null) {
            builder.equipSound(key3);
        }
        if (this.assetId != null && (assetId = (String)this.assetId.getSingle(event)) != null && (key2 = KeyUtils.getKey(assetId)) != null) {
            builder.assetId((Key)key2);
        }
        ArrayList<TypedKey> typedKeys = new ArrayList<TypedKey>();
        if (this.allowedEntities != null) {
            for (Object object : this.allowedEntities.getArray(event)) {
                RegistryKeySet keySet;
                TagKey tagKey;
                if (object instanceof EntityData) {
                    EntityData entityData = (EntityData)object;
                    EntityType bukkitEntityType = EntityUtils.toBukkitEntityType((EntityData)entityData);
                    TypedKey typedKey = TypedKey.create((RegistryKey)RegistryKey.ENTITY_TYPE, (Key)bukkitEntityType.key());
                    if (typedKeys.contains(typedKey)) continue;
                    typedKeys.add(typedKey);
                    continue;
                }
                if (object instanceof EntityType) {
                    EntityType entityType = (EntityType)object;
                    TypedKey typedKey = TypedKey.create((RegistryKey)RegistryKey.ENTITY_TYPE, (Key)entityType.key());
                    if (typedKeys.contains(typedKey)) continue;
                    typedKeys.add(typedKey);
                    continue;
                }
                if (object instanceof Tag) {
                    Tag tag = (Tag)object;
                    RegistryKeySet keySet2 = RegistryUtils.getKeySet(tag, RegistryKey.ENTITY_TYPE);
                    builder.allowedEntities(keySet2);
                    typedKeys.clear();
                    break;
                }
                if (object instanceof TagKey && (tagKey = (TagKey)object).registryKey() == RegistryKey.ENTITY_TYPE) {
                    TagKey entityTagKey = tagKey;
                    builder.allowedEntities((RegistryKeySet)RegistryUtils.getRegistry(RegistryKey.ENTITY_TYPE).getTag(entityTagKey));
                    typedKeys.clear();
                    break;
                }
                if (!(object instanceof RegistryKeySet) || (keySet = (RegistryKeySet)object).registryKey() != RegistryKey.ENTITY_TYPE) continue;
                RegistryKeySet entityKeySet = keySet;
                builder.allowedEntities(entityKeySet);
                typedKeys.clear();
                break;
            }
        }
        if (!typedKeys.isEmpty()) {
            RegistryKeySet keySet = RegistrySet.keySet((RegistryKey)RegistryKey.ENTITY_TYPE, typedKeys);
            builder.allowedEntities(keySet);
        }
        if (this.dispensable != null) {
            boolean dispensable = this.dispensable.getOptionalSingle(event).orElse(true);
            builder.dispensable(dispensable);
        }
        if (this.swappable != null) {
            boolean swappable = this.swappable.getOptionalSingle(event).orElse(true);
            builder.swappable(swappable);
        }
        if (this.damageOnHurt != null) {
            Boolean damageOnHurt = this.damageOnHurt.getOptionalSingle(event).orElse(true);
            builder.damageOnHurt(damageOnHurt.booleanValue());
        }
        if (this.cameraOverlay != null && (overlay = (String)this.cameraOverlay.getSingle(event)) != null && (key = KeyUtils.getKey(overlay)) != null) {
            builder.cameraOverlay(key);
        }
        Equippable equippable = (Equippable)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(DataComponentTypes.EQUIPPABLE, (Object)equippable));
        return super.walk(event, false);
    }

    public String toString(Event e, boolean d) {
        return "apply equippable component to " + this.items.toString(e, d);
    }

    static {
        Class[] classes = (Class[])CollectionUtils.array((Object[])new Class[]{EntityData.class, EntityType.class, Tag.class, TagKey.class, RegistryKeySet.class});
        VALIDATOR = SimpleEntryValidator.builder().addRequiredEntry("slot", EquipmentSlot.class).addOptionalEntry("equip_sound", String.class).addOptionalEntry("asset_id", String.class).addOptionalEntry("allowed_entities", classes).addOptionalEntry("dispensable", Boolean.class).addOptionalEntry("swappable", Boolean.class).addOptionalEntry("damage_on_hurt", Boolean.class).addOptionalEntry("camera_overlay", String.class).build();
        Skript.registerSection(SecEquippableComponent.class, (String[])new String[]{"apply equippable [component] to %itemstacks/itemtypes/slots%"});
    }
}

