/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Fireworks;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - Fireworks Component Apply")
@Description(value={"Apply a fireworks component to a firework rocket.", "Requires Paper 1.21.3+", "See [**Fireworks Component**](https://minecraft.wiki/w/Data_component_format#fireworks) on McWiki for more info.", "", "**Entries**:", "- `flight_duration` = The flight duration of this firework rocket, i.e. the number of gunpowders used to craft it. (Integer between 0 and 255, defaults to 1)", "- `explosions` = A section to apply firework explosions (see 'ItemComponent - Firework Explosion Component Apply' section)."})
@Examples(value={"apply fireworks to {_i}:", "\tflight_duration: 3", "\texplosions:", "\t\tapply firework explosion:", "\t\t\tshape: small ball", "\t\t\tcolors: red, yellow and white", "\t\t\tfade_colors: blue, green and red", "\t\t\thas_trail: true", "\t\t\thas_twinkle: true", "\t\tapply firework explosion:", "\t\t\tshape: large ball", "\t\t\tcolors: red, white and blue", "\t\t\thas_trail: false", "\t\t\thas_twinkle: false"})
@Since(value={"3.8.0"})
public class SecFireworksComponent
extends Section {
    private static final EntryValidator VALIDATOR = SimpleEntryValidator.builder().addRequiredSection("explosions").addOptionalEntry("flight_duration", Number.class).build();
    private Expression<?> items;
    private Expression<Number> flightDuration;
    private Trigger explosionsSection;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer validate = VALIDATOR.validate(sectionNode);
        if (validate == null) {
            return false;
        }
        this.items = exprs[0];
        this.flightDuration = (Expression)validate.getOptional("flight_duration", false);
        SectionNode rulesNode = (SectionNode)validate.getOptional("explosions", SectionNode.class, false);
        if (rulesNode != null) {
            this.explosionsSection = this.loadCode(rulesNode, "explosions section", new Class[]{FireworksExplosionsSectionEvent.class});
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Object localVars = Variables.copyLocalVariables((Event)event);
        Fireworks.Builder builder = Fireworks.fireworks();
        if (this.flightDuration != null) {
            Number num = this.flightDuration.getOptionalSingle(event).orElse(1);
            int duration = Math2.fit((int)0, (int)num.intValue(), (int)255);
            builder.flightDuration(duration);
        }
        if (this.explosionsSection != null) {
            FireworksExplosionsSectionEvent explosionsSectionEvent = new FireworksExplosionsSectionEvent(builder);
            Variables.setLocalVariables((Event)explosionsSectionEvent, (Object)localVars);
            TriggerItem.walk((TriggerItem)this.explosionsSection, (Event)explosionsSectionEvent);
            Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)explosionsSectionEvent));
            Variables.removeLocals((Event)explosionsSectionEvent);
        }
        Fireworks fireworks = (Fireworks)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(DataComponentTypes.FIREWORKS, (Object)fireworks));
        return super.walk(event, false);
    }

    public String toString(Event e, boolean d) {
        return "apply fireworks component to " + this.items.toString(e, d);
    }

    static {
        Skript.registerSection(SecFireworksComponent.class, (String[])new String[]{"apply fireworks [component] to %itemstacks/itemtypes/slots%"});
    }

    public static class FireworksExplosionsSectionEvent
    extends Event {
        private final Fireworks.Builder builder;

        public FireworksExplosionsSectionEvent(Fireworks.Builder builder) {
            this.builder = builder;
        }

        public Fireworks.Builder getBuilder() {
            return this.builder;
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException("FireworksExplosionsSectionEvent should never be called");
        }
    }
}

