/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.FoodProperties;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - Food Component Apply")
@Description(value={"Apply a food component to any item giving it food properties.", "You will also require a `consumable` component to actually make the item consumable.", "Requires Paper 1.21.3+", "See [**Food Component**](https://minecraft.wiki/w/Data_component_format#food) on McWiki for more details.", "", "**Entries/Sections**:", "- `nutrition` = The number of food points restored by this item when eaten. Must be a non-negative integer.", "- `saturation` = The amount of saturation restored by this item when eaten.", "- `can always eat` = If true, this item can be eaten even if the player is not hungry. Defaults to false. [Optional]"})
@Examples(value={"apply food component to player's tool:", "\tnutrition: 5", "\tsaturation: 3", "", "set {_i} to 1 of book", "apply food component to {_i}:", "\tnutrition: 5", "\tsaturation: 3", "\tcan_always_eat: true", "give player 1 of {_i}"})
@Since(value={"3.5.8"})
public class SecFoodComponent
extends Section {
    private static final EntryValidator VALIDATOR = SimpleEntryValidator.builder().addRequiredEntry("nutrition", Number.class).addRequiredEntry("saturation", Number.class).addOptionalEntry("can_always_eat", Boolean.class).build();
    private Expression<Object> items;
    private Expression<Number> nutrition;
    private Expression<Number> saturation;
    private Expression<Boolean> canAlwaysEat;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.items = exprs[0];
        this.nutrition = (Expression)container.getOptional("nutrition", false);
        this.saturation = (Expression)container.getOptional("saturation", false);
        this.canAlwaysEat = (Expression)container.getOptional("can_always_eat", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Number saturation;
        Number nutrition;
        FoodProperties.Builder builder = FoodProperties.food();
        if (this.nutrition != null && (nutrition = (Number)this.nutrition.getSingle(event)) != null) {
            builder.nutrition(Math.max(0, nutrition.intValue()));
        }
        if (this.saturation != null && (saturation = (Number)this.saturation.getSingle(event)) != null) {
            builder.saturation(saturation.floatValue());
        }
        if (this.canAlwaysEat != null) {
            boolean canAlwaysEat = this.canAlwaysEat.getOptionalSingle(event).orElse(false);
            builder.canAlwaysEat(canAlwaysEat);
        }
        FoodProperties food = (FoodProperties)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(DataComponentTypes.FOOD, (Object)food));
        return super.walk(event, false);
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "apply food component to " + this.items.toString(e, d);
    }

    static {
        Skript.registerSection(SecFoodComponent.class, (String[])new String[]{"apply food component to %itemstacks/itemtypes/slots%"});
    }
}

