/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.SimpleJavaFunction;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.DefaultClasses;
import ch.njol.util.Math2;
import com.shanebeestudios.skbee.api.registry.KeyUtils;
import com.shanebeestudios.skbee.api.wrapper.RegistryClassInfo;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Registry;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class Types {
    private static final ClassInfo<PotionEffect> POTION_EFFECTS = Classes.getExactClassInfo(PotionEffect.class);
    private static final ClassInfo<PotionEffectType> POTION_EFFECT_TYPE = Classes.getExactClassInfo(PotionEffectType.class);

    private static String getConsumeEffectString(ConsumeEffect consumeEffect) {
        if (consumeEffect instanceof ConsumeEffect.ApplyStatusEffects) {
            ConsumeEffect.ApplyStatusEffects applyStatusEffects = (ConsumeEffect.ApplyStatusEffects)consumeEffect;
            ArrayList<String> effects = new ArrayList<String>();
            for (PotionEffect effect : applyStatusEffects.effects()) {
                effects.add(Classes.toString((Object)effect));
            }
            return String.format("apply_effects [%s] with probability %s", String.join((CharSequence)", ", effects), Float.valueOf(applyStatusEffects.probability()));
        }
        if (consumeEffect instanceof ConsumeEffect.RemoveStatusEffects) {
            ConsumeEffect.RemoveStatusEffects removeStatusEffects = (ConsumeEffect.RemoveStatusEffects)consumeEffect;
            ArrayList<String> names = new ArrayList<String>();
            for (TypedKey removeEffect : removeStatusEffects.removeEffects()) {
                names.add(removeEffect.key().value());
            }
            return String.format("remove_effects [%s]", String.join((CharSequence)", ", names));
        }
        if (consumeEffect instanceof ConsumeEffect.ClearAllStatusEffects) {
            return "clear_all_effects";
        }
        if (consumeEffect instanceof ConsumeEffect.TeleportRandomly) {
            ConsumeEffect.TeleportRandomly teleportRandomly = (ConsumeEffect.TeleportRandomly)consumeEffect;
            return "teleport_randomly within diameter " + teleportRandomly.diameter();
        }
        if (consumeEffect instanceof ConsumeEffect.PlaySound) {
            ConsumeEffect.PlaySound playSound = (ConsumeEffect.PlaySound)consumeEffect;
            return "play_sound '" + String.valueOf(playSound.sound().key()) + "'";
        }
        return consumeEffect.toString();
    }

    static {
        ClassInfo CONSUME_EFFECT_INFO = new ClassInfo(ConsumeEffect.class, "consumeeffect").user(new String[]{"consume ?effects?"}).name("ItemComponent - Consume Effect").description(new String[]{"Represents an effect that is used in a consumable/death_protection item component.", "There are 5 consume effects: apply_effects, remove_effects, clear_all_effects, teleport_randomly and play_sound.", "Each of these has a function with the same name."}).parser((Parser)new Parser<ConsumeEffect>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(ConsumeEffect consumeEffect, int flags) {
                return Types.getConsumeEffectString(consumeEffect);
            }

            public String toVariableNameString(ConsumeEffect consumeEffect) {
                return this.toString(consumeEffect, 0);
            }
        }).since("3.8.0");
        Classes.registerClass((ClassInfo)CONSUME_EFFECT_INFO);
        Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.DATA_COMPONENT_TYPE, DataComponentType.class, false, "datacomponenttype").user(new String[]{"data ?component ?types?"}).name("Data Component Type").description(new String[]{"Represents the different types of data components."}).since("3.11.0"));
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<ConsumeEffect>("apply_effects", new Parameter[]{new Parameter("potion effects", POTION_EFFECTS, false, null), new Parameter("probability", DefaultClasses.NUMBER, true, null)}, CONSUME_EFFECT_INFO, true){

            public ConsumeEffect @Nullable [] executeSimple(Object[][] params) {
                List<PotionEffect> effects = Arrays.asList((PotionEffect[])params[0]);
                float prob = Math2.fit((float)0.0f, (float)((Number)params[1][0]).floatValue(), (float)1.0f);
                ConsumeEffect.ApplyStatusEffects applyStatusEffects = ConsumeEffect.applyStatusEffects(effects, (float)prob);
                return new ConsumeEffect[]{applyStatusEffects};
            }
        }.description(new String[]{"Create an 'apply_effects' consume effect.", "This will create a list of potion effects to be applied when consumed with a chance between 0 and 1.", "This can be used in a death protection/consumable component."}).examples(new String[]{"set {_p::1} to potion effect of night vision for 10 seconds", "set {_p::2} to potion effect of slow mining for 5 seconds", "set {_c} to apply_effects({_p::*}, 0.5)"}).since("3.8.0"));
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<ConsumeEffect>("remove_effects", new Parameter[]{new Parameter("potion effect types", POTION_EFFECT_TYPE, false, null)}, CONSUME_EFFECT_INFO, true){

            public ConsumeEffect @Nullable [] executeSimple(Object[][] params) {
                ArrayList<TypedKey> keys = new ArrayList<TypedKey>();
                for (Object object : params[0]) {
                    if (!(object instanceof PotionEffectType)) continue;
                    PotionEffectType pet = (PotionEffectType)object;
                    keys.add(TypedKey.create((RegistryKey)RegistryKey.MOB_EFFECT, (Key)pet.key()));
                }
                RegistryKeySet keySet = RegistrySet.keySet((RegistryKey)RegistryKey.MOB_EFFECT, keys);
                return new ConsumeEffect[]{ConsumeEffect.removeEffects((RegistryKeySet)keySet)};
            }
        }.description(new String[]{"Create a 'remove_effects' consume effect.", "This will create a list of potion effect types to be removed when consumed.", "This can be used in a death protection/consumable component."}).examples(new String[]{"set {_c} to remove_effects(night vision, poison)"}).since("3.8.0"));
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<ConsumeEffect>("clear_all_effects", new Parameter[0], CONSUME_EFFECT_INFO, true){

            public ConsumeEffect @Nullable [] executeSimple(Object[][] params) {
                return new ConsumeEffect[]{ConsumeEffect.clearAllStatusEffects()};
            }
        }.description(new String[]{"Create a 'clear_all_effects' consume effect.", "This will clear all effects when consumed.", "This can be used in a death protection/consumable component."}).examples(new String[]{"set {_c} to clear_all_effects()"}).since("3.8.0"));
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<ConsumeEffect>("teleport_randomly", new Parameter[]{new Parameter("diameter", DefaultClasses.NUMBER, true, null)}, CONSUME_EFFECT_INFO, true){

            public ConsumeEffect @Nullable [] executeSimple(Object[][] params) {
                Number diameter = (Number)params[0][0];
                ConsumeEffect.TeleportRandomly teleportRandomly = ConsumeEffect.teleportRandomlyEffect((float)diameter.floatValue());
                return new ConsumeEffect[]{teleportRandomly};
            }
        }.description(new String[]{"Create a 'teleport_randomly' consume effect.", "This will make the consumer teleport randomly when consumed.", "This can be used in a death protection/consumable component."}).examples(new String[]{"set {_c} to teleport_randomly(10)"}).since("3.8.0"));
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<ConsumeEffect>("play_sound", new Parameter[]{new Parameter("sound", DefaultClasses.STRING, true, null)}, CONSUME_EFFECT_INFO, true){

            public ConsumeEffect @Nullable [] executeSimple(Object[][] params) {
                String sound = (String)params[0][0];
                Key key = KeyUtils.getKey(sound);
                if (key == null) {
                    return null;
                }
                ConsumeEffect.PlaySound playSound = ConsumeEffect.playSoundConsumeEffect((Key)key);
                return new ConsumeEffect[]{playSound};
            }
        }.description(new String[]{"Create a 'play_sound' consume effect.", "Will play a sound when consumed.", "This can be used in a death protection/consumable component."}).examples(new String[]{"set {_c} to play_sound(\"minecraft:block.stone.break\")"}).since("3.8.0"));
    }
}

