/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - File Exists")
@Description(value={"Check if an NBT file already exists."})
@Examples(value={"if nbt file \"plugins/MyPlugin/test.nbt\" exists:"})
@Since(value={"2.10.0"})
public class CondNBTFileExists
extends Condition {
    private Expression<String> fileName;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fileName = exprs[0];
        this.setNegated(parseResult.hasTag("1"));
        return true;
    }

    public boolean check(Event event) {
        return this.fileName.check(event, NBTApi::nbtFileExists, this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String exists = this.isNegated() ? " doesn't exist" : " exists";
        return "nbt file " + this.fileName.toString(e, d) + exists;
    }

    static {
        Skript.registerCondition(CondNBTFileExists.class, (String[])new String[]{"nbt file %string% (exists|1:doesn't exist)"});
    }
}

