/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.skript.base.PropertyCondition;

@Name(value="NBT - Is Blank Compound")
@Description(value={"Checks whether or not the provided nbt compounds are empty."})
@Examples(value={"broadcast whether empty nbt compound is an empty nbt compound", "send whether nbt from \"{}\" is an empty nbt compound", "", "set {_nbt} to custom nbt copy of player's tool", "if {_nbt} is a blank nbt compound:", "\tbroadcast \"You got zero nbt ;(\""})
@Since(value={"INSERT VERSION"})
public class CondNBTIsBlank
extends PropertyCondition<NBTCompound> {
    public boolean check(NBTCompound nbtCompound) {
        return nbtCompound.getKeys().isEmpty();
    }

    protected String getPropertyName() {
        return "empty nbt compound";
    }

    static {
        CondNBTIsBlank.register(CondNBTIsBlank.class, (String)"[a[n]] (blank|empty) nbt compound", (String)"nbtcompounds");
    }
}

