/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Set Block with NBT")
@Description(value={"Set a block at a location to a block with NBT. BlockData is also supported when using MC 1.13+ and Skript 2.5+"})
@Examples(value={"set {_n} to nbt compound from \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&aFurnieFurnace\\\"\"}\"\"}\"", "set nbt-block at player to west facing furnace with nbt {_n}", "set nbt-block at player to furnace[facing=west] with nbt {_n}", "set {_n} to nbt compound from \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&cHoppieHopper\\\"\"}\"\"}\"", "set nbt-block at event-location to hopper with nbt {_n}", "set {_nbt} to nbt compound from \"{custom:{BlockOwner:\"%uuid of player%\"}}\"", "set nbt-block at player to coal ore with nbt {_n}"})
@Since(value={"1.0.0"})
public class EffSetBlockNBT
extends Effect {
    private Expression<Location> locations;
    private Expression<Object> type;
    private Expression<NBTCompound> nbt;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.type = exprs[2];
        this.locations = Direction.combine(exprs[0], exprs[1]);
        this.nbt = exprs[3];
        return true;
    }

    public void execute(@NotNull Event event) {
        NBTCompound compound = (NBTCompound)this.nbt.getSingle(event);
        if (compound == null) {
            return;
        }
        Object typeObject = this.type.getSingle(event);
        if (typeObject == null) {
            return;
        }
        for (Location loc : (Location[])this.locations.getArray(event)) {
            assert (loc != null) : this.locations;
            Block block = loc.getBlock();
            if (typeObject instanceof BlockData) {
                BlockData blockData = (BlockData)typeObject;
                block.setBlockData(blockData);
            } else {
                ItemType itemType = (ItemType)typeObject;
                itemType.setBlock(block, true);
            }
            NBTApi.addNBTToBlock(block, compound);
        }
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "set block " + this.locations.toString(e, debug) + " to " + this.type.toString(e, debug) + " with nbt " + this.nbt.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetBlockNBT.class, (String[])new String[]{"set (nbt[(-| )]block|tile[(-| )]entity) %directions% %locations% to %itemtype/blockdata% with [nbt] %nbtcompound%"});
    }
}

