/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.Comparator;
import java.util.Locale;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Tags")
@Description(value={"Get all tags of an NBT compound."})
@Examples(value={"set {_t::*} to nbt tags of {_n}", "set {_t::*} to nbt tags of nbt compound of player"})
@Since(value={"1.14.2"})
public class ExprTagsOfNBT
extends SimpleExpression<String> {
    private Expression<NBTCompound> compound;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.compound = exprs[0];
        return true;
    }

    protected String[] get(Event event) {
        NBTCompound compound = (NBTCompound)this.compound.getSingle(event);
        if (compound != null) {
            return (String[])compound.getKeys().stream().sorted(Comparator.comparing(key -> key.toLowerCase(Locale.ROOT))).toArray(String[]::new);
        }
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "nbt tags of nbt compound " + this.compound.toString(e, d);
    }

    static {
        PropertyExpression.register(ExprTagsOfNBT.class, String.class, (String)"nbt tags", (String)"nbtcompound");
    }
}

