/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Chunk;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Chunk - Contains BlockData")
@Description(value={"Check if a chunk contains a specific block data.", "This can be useful to check before looping blocks in a chunk."})
@Examples(value={"if chunk at player contains block data sand[]:"})
@Since(value={"2.5.2"})
public class CondChunkContainsBlockData
extends Condition {
    private Expression<Chunk> chunks;
    private Expression<BlockData> blockData;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.chunks = exprs[0];
        this.blockData = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.chunks.check(event, chunk -> this.blockData.check(event, arg_0 -> ((Chunk)chunk).contains(arg_0)), this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (Event)e, (boolean)d, this.chunks, (String)("blockdata " + this.blockData.toString(e, d)));
    }

    static {
        Skript.registerCondition(CondChunkContainsBlockData.class, (String[])new String[]{"%chunks% (has|have) block[ ]data %blockdata%", "%chunks% (doesn't|does not|do not|don't) have block[ ]data %blockdata%"});
    }
}

