/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.event.Event;

@Name(value="EntityBlockStorage - Is Full")
@Description(value={"Check if an entity storage block is fully of entities.", "As of 1.15 this only includes beehives/bee nests! Requires Spigot/Paper 1.15.2+"})
@Examples(value={"if entity storage of block at player is full:", "if entity storage of target block is not full:"})
@Since(value={"1.0.0"})
public class CondEntityStorageBlockFull
extends Condition {
    private Expression<Block> block;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.setNegated(i == 1);
        this.block = exprs[0];
        return true;
    }

    public boolean check(Event event) {
        BlockState state;
        Block block = (Block)this.block.getSingle(event);
        if (block != null && (state = block.getState()) instanceof EntityBlockStorage) {
            EntityBlockStorage storage = (EntityBlockStorage)state;
            return this.isNegated() != storage.isFull();
        }
        return this.isNegated();
    }

    public String toString(Event event, boolean b) {
        return null;
    }

    static {
        Skript.registerCondition(CondEntityStorageBlockFull.class, (String[])new String[]{"entity storage of %block% is full", "entity storage of %block% is(n't| not) full"});
    }
}

