/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Name(value="Break Blocks with Effects")
@Description(value={"Breaks blocks as if a player had broken them. Will drop items, play particles and sounds. Requires PaperMC.", "Optionally you can trigger it to drop experience as well.", "Optionally you can include an item which is used to determine which drops the block will drop."})
@Examples(value={"break blocks in radius 2 around target block with effects", "break {_blocks::*} with effects and with xp", "break {_blocks::*} with effects and with xp using player's tool"})
@Since(value={"3.6.1"})
public class EffBreakBlocksWithEffects
extends Effect {
    private static final boolean HAS_EFFECTS = Skript.methodExists(Block.class, (String)"breakNaturally", (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE});
    private boolean exp;
    private Expression<Block> blocks;
    private Expression<ItemType> itemType;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!HAS_EFFECTS) {
            Skript.error((String)"'break %blocks% with effects' requires PaperMC. Use Skript's 'break %blocks%' effect instead.");
            return false;
        }
        this.exp = parseResult.hasTag("exp");
        this.blocks = exprs[0];
        this.itemType = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        ItemType it;
        ItemStack itemStack = null;
        if (this.itemType != null && (it = (ItemType)this.itemType.getSingle(event)) != null) {
            itemStack = it.getRandom();
        }
        for (Block block : (Block[])this.blocks.getArray(event)) {
            if (itemStack != null) {
                block.breakNaturally(itemStack, true, this.exp);
                continue;
            }
            block.breakNaturally(true, this.exp);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String blocks = this.blocks.toString(e, d);
        String xp = this.exp ? " and with experience" : "";
        String it = this.itemType != null ? " using " + this.itemType.toString(e, d) : "";
        return "break " + blocks + " naturally with effects" + xp + it;
    }

    static {
        Skript.registerEffect(EffBreakBlocksWithEffects.class, (String[])new String[]{"break %blocks% [naturally] with effects [exp:[and] with (experience|exp|xp)] [using %-itemtype%]"});
    }
}

