/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Name(value="Send Equipment Change")
@Description(value={"Send an equipment change for an entity. This will not actually change the entity's equipment in any way."})
@Examples(value={"make player see hand slot of target entity as diamond sword", "make all players see off hand slot of player as shield"})
@Since(value={"3.4.0"})
public class EffEquipmentChange
extends Effect {
    private Expression<Player> players;
    private Expression<EquipmentSlot> slots;
    private Expression<LivingEntity> entities;
    private Expression<ItemType> itemtype;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.slots = exprs[1];
        this.entities = exprs[2];
        this.itemtype = exprs[3];
        return true;
    }

    protected void execute(Event event) {
        ItemType itemType = (ItemType)this.itemtype.getSingle(event);
        if (itemType == null) {
            return;
        }
        ItemStack itemStack = itemType.getRandom();
        for (Player player : (Player[])this.players.getArray(event)) {
            for (LivingEntity livingEntity : (LivingEntity[])this.entities.getArray(event)) {
                for (EquipmentSlot slot : (EquipmentSlot[])this.slots.getArray(event)) {
                    player.sendEquipmentChange(livingEntity, slot, itemStack);
                }
            }
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String players = this.players.toString(e, d);
        String slot = this.slots.toString(e, d);
        String entities = this.entities.toString(e, d);
        String item = this.itemtype.toString(e, d);
        return String.format("make %s see %s of %s as %s", players, slot, entities, item);
    }

    static {
        Skript.registerEffect(EffEquipmentChange.class, (String[])new String[]{"make %players% see %equipmentslots% of %livingentities% as %itemtype%"});
    }
}

