/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lidded;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Open Container Animation")
@Description(value={"Play the open/close animation on a lidded block (ie: chest, barrel or shulker box).", "Note: When using the open method, the block will basically be locked 'open', a player opening/closing the block will not close the lid.", "Requires Minecraft 1.16+"})
@Examples(value={"play open animation on target block", "play close animation on all blocks in radius 3 around player"})
@Since(value={"1.10.0"})
public class EffOpenContainerAnimation
extends Effect {
    private boolean open;
    private Expression<Block> blocks;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.open = parseResult.hasTag("open");
        this.blocks = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        for (Block block : (Block[])this.blocks.getArray(event)) {
            BlockState blockState = block.getState();
            if (!(blockState instanceof Lidded)) continue;
            Lidded lidded = (Lidded)blockState;
            if (this.open) {
                lidded.open();
                continue;
            }
            lidded.close();
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return String.format("play %s animation on %s", this.open ? "open" : "close", this.blocks.toString(e, d));
    }

    static {
        Skript.registerEffect(EffOpenContainerAnimation.class, (String[])new String[]{"play (:open|close) animation on %blocks%"});
    }
}

