/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import io.papermc.paper.math.Position;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Open Sign")
@Description(value={"Open a sign's GUI to a player, to allow them to edit it.", "`virtual`: (Added in Paper 1.21.5)", " - Allows opening a client side sign to a player.", " - You will have to send a client side sign to the player.", " - The sign must be within 9 blocks of the player.", " - You can use the `unchecked sign change` event to listen for changes to virtual signs.", "If not using `virtual`, the block must be placed in the world.", "Front/Back support added in MC 1.20."})
@Examples(value={"open sign gui of target block to player", "open target block's sign gui to player", "open sign back of target block to player"})
@Since(value={"1.5.2", "2.14.0 (sides)", "3.11.3 (virtual)"})
public class EffOpenSign
extends Effect {
    private static final boolean HAS_VIRTUAL = Skript.classExists((String)"io.papermc.paper.event.packet.UncheckedSignChangeEvent");
    private Expression<Location> locations;
    private Expression<Player> players;
    private boolean back;
    private boolean virtual;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.locations = Direction.combine(exprs[0], exprs[1]);
        this.players = exprs[2];
        this.back = parseResult.hasTag("back");
        this.virtual = parseResult.hasTag("virtual");
        if (this.virtual && !HAS_VIRTUAL) {
            Skript.error((String)"Virtual sign opening requires Paper 1.21.5+");
            return false;
        }
        return true;
    }

    protected void execute(@NotNull Event event) {
        Location location = (Location)this.locations.getSingle(event);
        if (location == null) {
            return;
        }
        BlockState block = location.getBlock().getState();
        if (this.virtual) {
            for (Player player : (Player[])this.players.getArray(event)) {
                player.openVirtualSign((Position)Position.block((Location)location), this.back ? Side.BACK : Side.FRONT);
            }
        } else if (block instanceof Sign) {
            Sign sign = (Sign)block;
            for (Player player : (Player[])this.players.getArray(event)) {
                player.openSign(sign, this.back ? Side.BACK : Side.FRONT);
            }
        } else {
            this.error("Block is not a sign: " + Classes.toString((Object)location.getBlock()));
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String side = this.back ? "back " : "front ";
        String virtual = this.virtual ? "virtual " : "";
        return "open " + virtual + "sign " + side + "for " + this.locations.toString(e, d) + " to " + this.players.toString(e, d);
    }

    static {
        Skript.registerEffect(EffOpenSign.class, (String[])new String[]{"open [:virtual] sign [gui] [(front|back:back)] [(for|of)] [%direction%] %location% to %players%", "open [%direction%] %location%'[s] [:virtual] sign [gui] [(front|back:back)] to %players%"});
    }
}

