/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Event;

@Name(value="Parse Effect")
@Description(value={"This will parse a string as an effect, and execute it. Works the same as Skript's 'effect commands'."})
@Examples(value={"on join:", "\tparse effect \"give player a diamond sword\""})
@Since(value={"1.15.0"})
public class EffParseEffect
extends Effect {
    private Expression<String> effects;
    private Expression<CommandSender> sender;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.effects = exprs[0];
        this.sender = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        ConsoleCommandSender sender = this.sender != null ? (CommandSender)this.sender.getSingle(event) : Bukkit.getConsoleSender();
        for (String s : (String[])this.effects.getArray(event)) {
            SkriptUtils.parseEffect(s, (CommandSender)sender);
        }
    }

    public String toString(Event e, boolean d) {
        return "parse effect '" + this.effects.toString(e, d) + "' from " + this.sender.toString(e, d);
    }

    static {
        if (Skript.methodExists(ParserInstance.class, (String)"get", (Class[])new Class[0])) {
            Skript.registerEffect(EffParseEffect.class, (String[])new String[]{"parse effect[s] %strings% [from %-commandsender%]"});
        }
    }
}

