/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.MathUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Send Block Damage")
@Description(value={"Send fake block damage to a player.", "\nNumber = The amount of damage (a number between 0 and 1) to be applied to the block.", "\nEntity = the entity who is damaging the block. An entity can only damage 1 block at a time.", "\nBy Entity/Number = The entity/entityID which damaged the block."})
@Examples(value={"make player see damage of target block as 0.5", "make player see damage of target block as 0.5 by random element of all entities", "make player see damage of target block as 0.5 from random integer between 1 and 10000"})
@Since(value={"2.6.0"})
public class EffSendBlockDamage
extends Effect {
    private Expression<Player> players;
    private Expression<Block> block;
    private Expression<Number> damage;
    private Expression<?> damager;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.methodExists(Player.class, (String)"sendBlockDamage", (Class[])new Class[]{Location.class, Float.TYPE})) {
            Skript.error((String)"This effect requires a PaperMC server.");
            return false;
        }
        this.players = exprs[0];
        this.block = exprs[1];
        this.damage = exprs[2];
        this.damager = exprs[3];
        return true;
    }

    protected void execute(Event event) {
        Block block;
        float damage = 0.0f;
        Number damageNum = (Number)this.damage.getSingle(event);
        if (damageNum != null) {
            damage = damageNum.floatValue();
        }
        damage = MathUtil.clamp(damage, 0.0f, 1.0f);
        int entityID = -1;
        if (this.damager != null) {
            Object damagerObj = this.damager.getSingle(event);
            if (damagerObj instanceof Entity) {
                Entity entity = (Entity)damagerObj;
                entityID = entity.getEntityId();
            } else if (damagerObj instanceof Number) {
                Number number = (Number)damagerObj;
                entityID = number.intValue();
            }
        }
        if ((block = (Block)this.block.getSingle(event)) == null) {
            return;
        }
        Location location = block.getLocation();
        for (Player player : (Player[])this.players.getArray(event)) {
            if (entityID > 0) {
                player.sendBlockDamage(location, damage, entityID);
                continue;
            }
            player.sendBlockDamage(location, damage);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String ent = this.damager != null ? " from " + this.damager.toString(e, d) : "";
        return "make " + this.players.toString(e, d) + " see damage of " + this.block.toString(e, d) + " as " + this.damage.toString(e, d) + ent;
    }

    static {
        Skript.registerEffect(EffSendBlockDamage.class, (String[])new String[]{"make %players% see damage of %block% as %number% [(by|from) %-entity/number%]"});
    }
}

