/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Show/Hide Entities")
@Description(value={"Show/hide entities to/from players. Requires Minecraft 1.18+", "NOTE: This is not persistent across server restarts and/or chunk unloading!"})
@Examples(value={"make all entities disappear from player", "make all mobs appear to all players", "make target entity of player disappear from all players"})
@Since(value={"2.10.0"})
public class EffShowHideEntity
extends Effect {
    private static final SkBee PLUGIN = SkBee.getPlugin();
    private Expression<Entity> entities;
    private Expression<Player> players;
    private boolean appear;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.players = exprs[1];
        this.appear = parseResult.hasTag("1");
        return true;
    }

    protected void execute(Event event) {
        for (Player player : (Player[])this.players.getArray(event)) {
            for (Entity entity : (Entity[])this.entities.getArray(event)) {
                if (this.appear) {
                    player.showEntity((Plugin)PLUGIN, entity);
                    continue;
                }
                player.hideEntity((Plugin)PLUGIN, entity);
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String appear = this.appear ? " appear" : " disappear";
        return "make " + this.entities.toString(e, d) + appear + " for " + this.players.toString(e, d);
    }

    static {
        if (Skript.methodExists(Player.class, (String)"showEntity", (Class[])new Class[]{Plugin.class, Entity.class})) {
            Skript.registerEffect(EffShowHideEntity.class, (String[])new String[]{"make %entities% (1:appear|disappear) (for|to|from) %players%"});
        }
    }
}

