/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

@Name(value="Task - Cancel Task")
@Description(value={"Stop a task by ID.", "If running Folia, this effect will do nothing."})
@Examples(value={"run 0 ticks later repeating every second:", "\tset {-id} to current task id", "\tadd 1 to {_a}", "\tif {_a} > 10:", "\t\texit loop", "", "on break:", "\tstop task with id {-id}"})
@Since(value={"3.3.0"})
public class EffTaskStop
extends Effect {
    private static final BukkitScheduler SCHEDULER = Bukkit.getScheduler();
    private Expression<Number> ids;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.ids = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        for (Number id : (Number[])this.ids.getArray(event)) {
            SCHEDULER.cancelTask(id.intValue());
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "stop task[s] with id[s] " + this.ids.toString(e, d);
    }

    static {
        if (!Util.IS_RUNNING_FOLIA) {
            Skript.registerEffect(EffTaskStop.class, (String[])new String[]{"(stop|cancel) task[s] with id[s] %numbers%"});
        }
    }
}

