/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.events;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtSpawnerSpawn
extends SkriptEvent {
    private Literal<EntityData<?>> spawnedEntities;

    public boolean init(Literal<?>[] literals, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.spawnedEntities = literals[0];
        return true;
    }

    public boolean check(Event event) {
        if (this.spawnedEntities == null) {
            return true;
        }
        if (event instanceof SpawnerSpawnEvent) {
            SpawnerSpawnEvent spawnerEvent = (SpawnerSpawnEvent)event;
            Entity spawnedEntity = spawnerEvent.getEntity();
            return this.spawnedEntities.check(event, entityData -> entityData.isInstance(spawnedEntity));
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "spawner spawn" + (String)(this.spawnedEntities != null ? " of " + this.spawnedEntities.toString(e, d) : "");
    }

    static {
        Skript.registerEvent((String)"Spawner Spawn", EvtSpawnerSpawn.class, SpawnerSpawnEvent.class, (String[])new String[]{"spawner spawn[ing] [of %entitydatas%]"}).description(new String[]{"Called whenever an entity is spawned via a spawner."}).examples(new String[]{"on spawner spawn of zombie:", "\treset spawner timer of event-block"}).since("2.16.0");
        EventValues.registerEventValue(SpawnerSpawnEvent.class, Block.class, event -> {
            CreatureSpawner spawner = event.getSpawner();
            if (spawner != null) {
                return spawner.getBlock();
            }
            return null;
        }, (int)0);
    }
}

