/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Beacon - Entities in Effect Range")
@Description(value={"Returns a list of entities in the effect range of a beacon."})
@Examples(value={"command /effected_entities:", "\ttrigger:", "\t\tset {_block} to target block of player", "\t\tsend all entities in beacon effect range of {_block}"})
@Since(value={"2.16.0"})
public class ExprBeaconEntitiesInRange
extends SimpleExpression<LivingEntity> {
    private EntityData<?>[] entities;
    private Expression<Block> blocks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = exprs[1];
        this.entities = (EntityData[])((Literal)exprs[0]).getArray();
        return true;
    }

    @Nullable
    protected LivingEntity[] get(Event event) {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (Block block : (Block[])this.blocks.getArray(event)) {
            BlockState blockState = block.getState();
            if (!(blockState instanceof Beacon)) continue;
            Beacon beacon = (Beacon)blockState;
            for (LivingEntity entity2 : beacon.getEntitiesInRange()) {
                if (entities.contains(entity2)) continue;
                entities.add(entity2);
            }
        }
        return entities.stream().filter(entity -> {
            for (EntityData<?> Entitydata : this.entities) {
                if (!Entitydata.isSupertypeOf(EntityData.fromEntity((Entity)entity))) continue;
                return true;
            }
            return false;
        }).toList().toArray(new LivingEntity[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends LivingEntity> getReturnType() {
        return LivingEntity.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return Classes.toString((Object[])this.entities, (boolean)false) + " in beacon effect range of " + this.blocks.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBeaconEntitiesInRange.class, LivingEntity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all [[of] the]|the] %*entitydatas% in [beacon] effect range of %blocks%"});
    }
}

