/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.PropertyExpression;
import com.shanebeestudios.skbee.api.util.BlockDataUtils;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockData - Item BlockData Tag")
@Description(value={"Get/set the value of a tag in the BlockData of an item."})
@Examples(value={""})
@Since(value={"3.4.0"})
public class ExprBlockDataItemTag
extends PropertyExpression<ItemType, Object> {
    private Expression<String> tag;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.tag = exprs[matchedPattern];
        this.setExpr(exprs[1 - matchedPattern]);
        return true;
    }

    protected Object[] get(Event event, ItemType[] source) {
        return this.get(source, itemType -> {
            ItemMeta patt0$temp = itemType.getItemMeta();
            if (!(patt0$temp instanceof BlockDataMeta)) {
                return null;
            }
            BlockDataMeta meta = (BlockDataMeta)patt0$temp;
            Material blockForm = BlockDataUtils.getBlockForm(itemType.getMaterial());
            if (blockForm == null || !blockForm.isBlock()) {
                return null;
            }
            BlockData blockData = meta.getBlockData(blockForm);
            return BlockDataUtils.getBlockDataValueFromTag(blockData, (String)this.tag.getSingle(event));
        });
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        String tag = (String)this.tag.getSingle(event);
        if (tag == null) {
            this.error("No tag found: " + this.tag.toString(event, true));
            return;
        }
        for (ItemType itemType : (ItemType[])this.getExpr().getAll(event)) {
            Material blockForm = BlockDataUtils.getBlockForm(itemType.getMaterial());
            if (blockForm == null || !blockForm.isBlock()) continue;
            BlockDataMeta itemMeta = (BlockDataMeta)itemType.getItemMeta();
            BlockData oldBlockData = itemMeta.getBlockData(blockForm);
            BlockData newBlockData = BlockDataUtils.setBlockDataTag(oldBlockData, tag, delta[0]);
            if (newBlockData == null) {
                this.tagError("Invalid tag \"" + tag + "\" for this blockdata: " + oldBlockData.getAsString());
                continue;
            }
            itemMeta.setBlockData(newBlockData);
            itemType.setItemMeta((ItemMeta)itemMeta);
        }
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "item blockdata tag " + this.tag.toString(e, d) + " of " + this.getExpr().toString(e, d);
    }

    private void tagError(String message) {
        this.errorRegex(message, "tag \\\"\\w+\\\"");
    }

    static {
        PropertyExpression.register(ExprBlockDataItemTag.class, Object.class, (String)"item [block[ ]](data|state) tag %string%", (String)"itemtypes");
    }
}

