/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block - Relative")
@Description(value={"Get a block relative to another block using a BlockFace."})
@Examples(value={"set {_rel} to block relative to target block using {_blockFace}", "set block relative to target block using north to stone"})
@Since(value={"2.6.0"})
public class ExprBlockRelative
extends SimpleExpression<Block> {
    private Expression<Block> block;
    private Expression<BlockFace> blockFaces;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.block = exprs[0];
        this.blockFaces = exprs[1];
        return true;
    }

    @Nullable
    protected Block[] get(Event event) {
        Block block = (Block)this.block.getSingle(event);
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (block == null) {
            return null;
        }
        for (BlockFace blockFace : (BlockFace[])this.blockFaces.getArray(event)) {
            blocks.add(block.getRelative(blockFace));
        }
        return blocks.toArray(new Block[0]);
    }

    public boolean isSingle() {
        return this.blockFaces.isSingle();
    }

    @NotNull
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "block[s] relative to " + this.block.toString(e, d) + " using " + this.blockFaces.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBlockRelative.class, Block.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"block[s] relative to %block% (from|using) %blockfaces%"});
    }
}

