/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Chat Completions")
@Description(value={"Represents the chat completions of a player.", "\n`set` = Set the list of chat completion suggestions shown to the player while typing a message.", "If completions were set previously, this method will remove them all and replace them with the provided completions.", "\n`add` = Add custom chat completion suggestions shown to the player while typing a message.", "\n`remove` = Remove custom chat completion suggestions shown to the player while typing a message. Online player names cannot be removed with this method.", "This will affect only custom completions added by add/set.", "\n`reset` = Will remove all custom chat completions.", "\nNOTE: Supports all objects, will be stringified based on however Skript does it."})
@Examples(value={"add \"i like cheese\" to chat completions of player", "add all worlds to chat completions of player", "set chat completions of player to \"potatoes\" and \"popcorn\"", "reset chat completions of player"})
@Since(value={"2.17.0"})
public class ExprChatCompletions
extends PropertyExpression<Player, String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected String[] get(Event event, Player[] players) {
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ArrayList<String> completions = new ArrayList<String>();
        if (delta != null) {
            for (Object object : delta) {
                if (object instanceof String) {
                    String string = (String)object;
                    completions.add(string);
                    continue;
                }
                completions.add(Classes.toString((Object)object));
            }
        }
        for (Player player : (Player[])this.getExpr().getArray(event)) {
            if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
                player.setCustomChatCompletions(completions);
                continue;
            }
            if (mode == Changer.ChangeMode.ADD) {
                player.addCustomChatCompletions(completions);
                continue;
            }
            if (mode != Changer.ChangeMode.REMOVE) continue;
            player.removeCustomChatCompletions(completions);
        }
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "chat completions of " + this.getExpr().toString(e, d);
    }

    static {
        if (Skript.methodExists(Player.class, (String)"setCustomChatCompletions", (Class[])new Class[]{Collection.class})) {
            ExprChatCompletions.register(ExprChatCompletions.class, String.class, (String)"[custom] chat completions", (String)"players");
        }
    }
}

